% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_ant.R
\name{canvas_ant}
\alias{canvas_ant}
\title{Paint Langton's Ant on a Canvas}
\usage{
canvas_ant(colors, background = '#fafafa', iterations = 1e7,
           width = 200, height = 200)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{width}{a positive integer specifying the width of the artwork in pixels.}

\item{height}{a positive integer specifying the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints Langton's Ant. Langton's ant is a two-dimensional universal Turing machine with a very simple set of rules but complex emergent behavior.
}
\examples{
\donttest{
set.seed(1)
palette <- colorPalette('random', n = 10)
canvas_ant(colors = palette)
}

}
\references{
\url{https://en.wikipedia.org/wiki/Langtons_ant}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
