% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchAngle.R
\docType{methods}
\name{BranchAngle}
\alias{BranchAngle}
\alias{BranchAngle,aRchi-method}
\title{Estimation of the tree branch angle from an aRchi file}
\usage{
BranchAngle(aRchi, method = NULL, A0 = FALSE, level = "Tree")

\S4method{BranchAngle}{aRchi}(aRchi, method = NULL, A0 = FALSE, level = "Tree")
}
\arguments{
\item{aRchi}{an object of class aRchi with at least a QSM and a path table}

\item{method}{character. \code{SegmentAngle} or \code{King98}}

\item{A0}{logical (default = FALSE). If TRUE the main axis to remove from the calculation is re-estimated using the \code{\link{Compute_A0}} function. If false the default branch order 0 is kept.}

\item{level}{character. The level at which the branch angle is computed. \code{Tree} for tree level; \code{branching_order} for branch order level; \code{Axis} one angle value per axis.}
}
\value{
a numeric or data.table. The branch angle in degree at the selected level. with 0 a perfectly vertical branch angle, 90 a perfectly horizontal branch angle and > 90 a downward branch angle
}
\description{
Estimate the branch angle of a QSM. Two methods are possible (see method argument)
}
\details{
The method "SegmentAngle" compute the angle by considering the first and the last cylinder or each segment, mean is then used for the level of organization selected.

The method "King98" compute the angle by considering the first and the last cylinder of each axis mean is then used for the level of organization selected.

The main axis is always removed.
}
\examples{
\donttest{
# Read an aRchi file with a QSM and paths tables.
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)
# Compute the branch angle at various level
BranchAngle(Tree1_aRchi,method="SegmentAngle")
BranchAngle(Tree1_aRchi,level="branching_order",method="SegmentAngle",A0=TRUE)
}
}
\references{
Martin-Ducup, O. et al. Terrestrial laser scanning reveals convergence of tree architecture with increasingly dominant crown canopy position. Functional Ecology (2020).
}
