% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectinQSM_3d.R
\docType{methods}
\name{SelectinQSM_3d}
\alias{SelectinQSM_3d}
\alias{SelectinQSM_3d,aRchi-method}
\title{SelectinQSM_3d}
\usage{
SelectinQSM_3d(aRchi, skeleton = TRUE, level = "cylinder")

\S4method{SelectinQSM_3d}{aRchi}(aRchi, skeleton = TRUE, level = "cylinder")
}
\arguments{
\item{aRchi}{An object of class aRchi}

\item{skeleton}{logical. Display the skeleton only. Default is \code{TRUE}. Faster than displaying the QSM with the fleshed cylinders.}

\item{level}{character. \code{cylinder} (default), \code{segment}, \code{node}, \code{axis}, \code{branch}, \code{subtree}.}
}
\value{
a data.table with the cylinders characteristics at the requested level (i.e sub-part of the original QSM).
}
\description{
Select interactively a sub-part of a QSM (cylinder, segment, node, axis, branch, subtree) in a 3d device and return its characteristics.
}
\details{
The selection is performed in two times: i) Identifying the zone of interest in the 3d device and zoom into it if needed. When identified, the user has to hit enter in the R console. At this point, it is impossible to rotate the displayed QSM anymore as the left button of the mouse is used for the selection. However translation are still possible with the right button. ii) Draw a rectangle with the left button of the mouse in the zone of interest.

Some details about the level of organization are given below.

 "cylinder": return characteristics for the cylinders selected only

 "segment:" return characteristics for the cylinders of the segments selected

 "node": return the characteristics for the cylinders of the node selected. For a specific node, select the mother.

 "axis": return the characteristics for the cylinders of the axis selected. An axis is a continuous succession of cylinder having a same branching order value.

 "branch": return the characteristics for the cylinders of the branch selected. A branch is similar to an axis but regroup also everything that is upstream the axis (i.e all that the axis carries)

 "subtree": return the characteristics for the cylinders of the subtree selected. A subtree is similar to a branch but starting from the cylinder selected and not from the point of insertion of the selected axis. In other word, when the user draw a rectangle on a cylinder, the subtree selection return all that the cylinder carries. If several cylinders are selected, the subtree selection return all that the most downstream cylinder carries.
}
\examples{
# Read an aRchi file with at least a QSM
if(interactive()){
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)
# Select a branch
SelectinQSM_3d(Tree1_aRchi,level="branch")
# Same with the fleshed cylinder and keep the branch QSM in an object
My_branch=SelectinQSM_3d(Tree1_aRchi,level="branch",skeleton=FALSE)
My_branch
# Compute the moment of force
Tree1_aRchi=Compute_Mf(Tree1_aRchi,WoodDensity=550)
#Select a cylinder to return the moment of force at his position
SelectinQSM_3d(Tree1_aRchi,skeleton=FALSE)
}
}
