% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot,aRchi,ANY-method}
\alias{plot,aRchi,ANY-method}
\title{Plot an object of class aRchi}
\usage{
\S4method{plot}{aRchi,ANY}(
  x,
  y,
  transparency = 1,
  color = "white",
  bg = "black",
  lwd = 3,
  show_point_cloud = FALSE,
  skeleton = TRUE,
  leaves = FALSE,
  lit = TRUE
)
}
\arguments{
\item{x}{An aRchi object}

\item{y}{Unused (inherited from R base)}

\item{transparency}{The transparency of the cylinders}

\item{color}{The color of the cylinders. Can be either a single color or a level of organization:
"branching_order" for branching branching_order, "cylinder" to coloryze each cylinder independently, "segment" to coloryze the branch segments, "axis" to coloryze the axis, "A0" to colorize only the main axis from \code{\link{Compute_A0}} function}

\item{bg}{The background color}

\item{lwd}{line width of the skeleton}

\item{show_point_cloud}{logical (Default = \code{FALSE}). Display the point cloud ?}

\item{skeleton}{logical (Default is \code{TRUE}). Display the skeleton only (i.e segments). Faster than displaying the whole QSM with the fleshed cylinders.}

\item{leaves}{logical (Default is \code{FALSE}). Display the leaves ?}

\item{lit}{logical (Default is \code{TRUE}). Specify if lighting calculation should take place on the geometry. Only applies if \code{skeleton = FALSE}.}
}
\description{
Plot an object of class aRchi.
}
\details{
Plot an object of class aRchi in a 3d device. The QSM can be plotted according to different level of organization and the point cloud can be displayed if available.
}
\examples{
\donttest{
# Read an aRchi file with at least a QSM
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)
# Plot the QSM by coloring the branching order
plot(Tree1_aRchi,color="branching_order")
# Same with the fleshed cylinder and the point cloud
plot(Tree1_aRchi,color="branching_order",skeleton=FALSE,show_point_cloud=TRUE)
}


}
