% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Factorial.Double.R
\name{Factorial.Double}
\alias{Factorial.Double}
\alias{A000165}
\alias{A001147}
\title{Double Factorial numbers}
\usage{
Factorial.Double(n, Rmpfr = TRUE, PrecisionBits = 496, odd = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}

\item{odd}{a logical; \code{TRUE} for double factorial of odd numbers, \code{FALSE} for even numbers.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000165}{A000165} and \href{https://oeis.org/A001147}{A001147}, a \emph{Double Factorial} is the factorial of numbers with same parity.
For example, if \eqn{n=5}, then \eqn{n!!=5*3*1}.
}
\examples{
## generate first 10 Factorials
first10 = Factorial(10)

## print without trailing 0's.
print(first10, drop0trailing = TRUE)

}
\seealso{
\code{\link{Factorial}}
}
