% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extravagant.R
\name{Extravagant}
\alias{Extravagant}
\alias{A046760}
\alias{Wasteful}
\title{Extravagant numbers}
\usage{
Extravagant(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A046760}{A046760}, an \emph{Extravagant} number has less digits
than the number of digits in its prime factorization including exponents. First 6 Extravagant numbers are   	4, 6, 8, 9, 12, 18. Though
it doesn't matter which base we use, here we adopt only a base of 10.
}
\examples{
## generate first 20 Extravagant numbers
first20 = Extravagant(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
\seealso{
\code{\link{Frugal}}, \code{\link{Equidigital}}
}
