% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_method_01_pasteXML.R
\docType{methods}
\name{pasteXML}
\alias{pasteXML}
\alias{pasteXML,-methods}
\alias{pasteXMLNode}
\alias{pasteXMLTree}
\alias{pasteXML,XiMpLe_node-method}
\alias{pasteXML,XiMpLe_doc-method}
\title{Paste methods for XiMpLe XML objects}
\usage{
pasteXML(obj, ...)

\S4method{pasteXML}{XiMpLe_node}(
  obj,
  level = 1,
  shine = 1,
  indent.by = getOption("XiMpLe_indent", "\\t"),
  tidy = TRUE,
  tidy.omit = c("![CDATA[", "*![CDATA["),
  as_script = FALSE,
  func_rename = c(`?xml_` = "xml_", `!--_` = "comment_", `![CDATA[_` = "CDATA_",
    `!DOCTYPE_` = "DOCTYPE_")
)

\S4method{pasteXML}{XiMpLe_doc}(
  obj,
  shine = 1,
  indent.by = getOption("XiMpLe_indent", "\\t"),
  tidy = TRUE,
  tidy.omit = c("![CDATA[", "*![CDATA["),
  as_script = FALSE,
  func_rename = c(`?xml_` = "xml_", `!--_` = "comment_", `![CDATA[_` = "CDATA_",
    `!DOCTYPE_` = "DOCTYPE_")
)
}
\arguments{
\item{obj}{An object of class \code{XiMpLe_node} or \code{XiMpLe_doc}.}

\item{...}{Additional options for the generic method, see options for a specific method,
      respectively.}

\item{level}{Indentation level.}

\item{shine}{Integer,
      controlling if the output should be formatted for better readability. Possible values:
\describe{
  \item{0}{No formatting.}
  \item{1}{Nodes will be indented.}
  \item{2}{Nodes will be indented and each attribute gets a new line.}
}}

\item{indent.by}{A charachter string defining how indentation should be done. Defaults to tab.}

\item{tidy}{Logical,
      if \code{TRUE} the special characters "<" and ">" will be replaced with the entities
"&lt;" and "gt;" in attributes and text values.}

\item{tidy.omit}{A character vector with node names that should be excluded from \code{tidy}.}

\item{as_script}{Logical, if \code{TRUE},
      tags will be pasted as a sketch for a script to be run in conjunction with
functions generated by \code{\link[XiMpLe:gen_tag_functions]{gen_tag_functions}}. This script code will most
likely not run without adjustments, but is perhaps a good start anyway.}

\item{func_rename}{Named character vector defining which tags' functions should get a different name.
This makes it easier to get functions with valid names that generate special tag nodes.
Only used when \code{as_script=TRUE}. Use the same names and values as you used in
\code{\link[XiMpLe:gen_tag_functions]{gen_tag_functions}}.}
}
\description{
These methods can be used to paste objects if class \code{\link[XiMpLe:XiMpLe_node-class]{XiMpLe_node}}
or \code{\link[XiMpLe:XiMpLe_doc-class]{XiMpLe_doc}}.
}
\note{
The functions pasteXMLNode() and pasteXMLTree() have been replaced by the pasteXML methods.
   They should no longer be used.
}
\seealso{
\code{\link[XiMpLe:XiMpLe_node-class]{XiMpLe_node}}, 
   \code{\link[XiMpLe:XiMpLe_doc-class]{XiMpLe_doc}}
}
\keyword{methods}
