% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Interface.R
\docType{class}
\name{Unconvertible-class}
\alias{Unconvertible-class}
\title{Unconverted Server Language Objects}
\description{
Objects from this class represent server language objects whose conversion was requested
but which are judged (by the server side of the interface) to have no equivalent R form.
Rather than generating an error, the interface returns an object of this class, which can
have convertible attributes.  Fields of a convertible object may be unconvertible without
preventing conversion of the rest of the parent object.
}
\section{Slots}{

\describe{
\item{\code{serverClass,serverModule}}{The names of the class and module in the server language.}

\item{\code{language}}{The language name (for communicating with users), not the interface class name.}

\item{\code{attributes}}{A list with names that should be interpreted as properties of the object.}
}}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 12, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}

