/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.AutoFilterInfoRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.WorksheetProtectionBlock;
import org.apache.poi.hssf.usermodel.HSSFAutoFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.SSCellRange;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFSheet
implements Sheet {
    private static final POILogger log = POILogFactory.getLogger(HSSFSheet.class);
    private static final int DEBUG = POILogger.DEBUG;
    public static final int INITIAL_CAPACITY = 20;
    private final InternalSheet _sheet;
    private final TreeMap<Integer, HSSFRow> _rows;
    protected final InternalWorkbook _book;
    protected final HSSFWorkbook _workbook;
    private HSSFPatriarch _patriarch;
    private int _firstrow;
    private int _lastrow;

    protected HSSFSheet(HSSFWorkbook workbook) {
        this._sheet = InternalSheet.createSheet();
        this._rows = new TreeMap();
        this._workbook = workbook;
        this._book = workbook.getWorkbook();
    }

    protected HSSFSheet(HSSFWorkbook workbook, InternalSheet sheet) {
        this._sheet = sheet;
        this._rows = new TreeMap();
        this._workbook = workbook;
        this._book = workbook.getWorkbook();
        this.setPropertiesFromSheet(sheet);
    }

    HSSFSheet cloneSheet(HSSFWorkbook workbook) {
        return new HSSFSheet(workbook, this._sheet.cloneSheet());
    }

    @Override
    public HSSFWorkbook getWorkbook() {
        return this._workbook;
    }

    private void setPropertiesFromSheet(InternalSheet sheet) {
        boolean rowRecordsAlreadyPresent;
        RowRecord row = sheet.getNextRow();
        boolean bl = rowRecordsAlreadyPresent = row != null;
        while (row != null) {
            this.createRowFromRecord(row);
            row = sheet.getNextRow();
        }
        Iterator<CellValueRecordInterface> iter = sheet.getCellValueIterator();
        long timestart = System.currentTimeMillis();
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"Time at start of cell creating in HSSF sheet = ", timestart);
        }
        HSSFRow lastrow = null;
        while (iter.hasNext()) {
            CellValueRecordInterface cval = iter.next();
            long cellstart = System.currentTimeMillis();
            HSSFRow hrow = lastrow;
            if (hrow == null || hrow.getRowNum() != cval.getRow()) {
                lastrow = hrow = this.getRow(cval.getRow());
                if (hrow == null) {
                    if (rowRecordsAlreadyPresent) {
                        throw new RuntimeException("Unexpected missing row when some rows already present");
                    }
                    RowRecord rowRec = new RowRecord(cval.getRow());
                    sheet.addRow(rowRec);
                    hrow = this.createRowFromRecord(rowRec);
                }
            }
            if (log.check(POILogger.DEBUG)) {
                log.log(DEBUG, "record id = " + Integer.toHexString(((Record)((Object)cval)).getSid()));
            }
            hrow.createCellFromRecord(cval);
            if (!log.check(POILogger.DEBUG)) continue;
            log.log(DEBUG, (Object)"record took ", System.currentTimeMillis() - cellstart);
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"total sheet cell creation took ", System.currentTimeMillis() - timestart);
        }
    }

    @Override
    public HSSFRow createRow(int rownum) {
        HSSFRow row = new HSSFRow(this._workbook, this, rownum);
        row.setHeight(this.getDefaultRowHeight());
        this.addRow(row, true);
        return row;
    }

    private HSSFRow createRowFromRecord(RowRecord row) {
        HSSFRow hrow = new HSSFRow(this._workbook, this, row);
        this.addRow(hrow, false);
        return hrow;
    }

    @Override
    public void removeRow(Row row) {
        HSSFRow hrow = (HSSFRow)row;
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        for (Cell cell : row) {
            HSSFCell xcell = (HSSFCell)cell;
            if (!xcell.isPartOfArrayFormulaGroup()) continue;
            String msg = "Row[rownum=" + row.getRowNum() + "] contains cell(s) included in a multi-cell array formula. You cannot change part of an array.";
            xcell.notifyArrayFormulaChanging(msg);
        }
        if (this._rows.size() > 0) {
            Integer key = row.getRowNum();
            HSSFRow removedRow = this._rows.remove(key);
            if (removedRow != row) {
                throw new IllegalArgumentException("Specified row does not belong to this sheet");
            }
            if (hrow.getRowNum() == this.getLastRowNum()) {
                this._lastrow = this.findLastRow(this._lastrow);
            }
            if (hrow.getRowNum() == this.getFirstRowNum()) {
                this._firstrow = this.findFirstRow(this._firstrow);
            }
            this._sheet.removeRow(hrow.getRowRecord());
        }
    }

    private int findLastRow(int lastrow) {
        if (lastrow < 1) {
            return 0;
        }
        int rownum = lastrow - 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum > 0) {
            r = this.getRow(--rownum);
        }
        if (r == null) {
            return 0;
        }
        return rownum;
    }

    private int findFirstRow(int firstrow) {
        int rownum = firstrow + 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum <= this.getLastRowNum()) {
            r = this.getRow(++rownum);
        }
        if (rownum > this.getLastRowNum()) {
            return 0;
        }
        return rownum;
    }

    private void addRow(HSSFRow row, boolean addLow) {
        boolean firstRow;
        this._rows.put(row.getRowNum(), row);
        if (addLow) {
            this._sheet.addRow(row.getRowRecord());
        }
        boolean bl = firstRow = this._rows.size() == 1;
        if (row.getRowNum() > this.getLastRowNum() || firstRow) {
            this._lastrow = row.getRowNum();
        }
        if (row.getRowNum() < this.getFirstRowNum() || firstRow) {
            this._firstrow = row.getRowNum();
        }
    }

    @Override
    public HSSFRow getRow(int rowIndex) {
        return this._rows.get(rowIndex);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    @Override
    public int getFirstRowNum() {
        return this._firstrow;
    }

    @Override
    public int getLastRowNum() {
        return this._lastrow;
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        if (dataValidation == null) {
            throw new IllegalArgumentException("objValidation must not be null");
        }
        HSSFDataValidation hssfDataValidation = (HSSFDataValidation)dataValidation;
        DataValidityTable dvt = this._sheet.getOrCreateDataValidityTable();
        DVRecord dvRecord = hssfDataValidation.createDVRecord(this);
        dvt.addDataValidation(dvRecord);
    }

    public void setColumnHidden(short columnIndex, boolean hidden) {
        this.setColumnHidden(columnIndex & 0xFFFF, hidden);
    }

    public boolean isColumnHidden(short columnIndex) {
        return this.isColumnHidden(columnIndex & 0xFFFF);
    }

    public void setColumnWidth(short columnIndex, short width) {
        this.setColumnWidth(columnIndex & 0xFFFF, width & 0xFFFF);
    }

    public short getColumnWidth(short columnIndex) {
        return (short)this.getColumnWidth(columnIndex & 0xFFFF);
    }

    public void setDefaultColumnWidth(short width) {
        this.setDefaultColumnWidth(width & 0xFFFF);
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        this._sheet.setColumnHidden(columnIndex, hidden);
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        return this._sheet.isColumnHidden(columnIndex);
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        this._sheet.setColumnWidth(columnIndex, width);
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return this._sheet.getColumnWidth(columnIndex);
    }

    @Override
    public int getDefaultColumnWidth() {
        return this._sheet.getDefaultColumnWidth();
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this._sheet.setDefaultColumnWidth(width);
    }

    @Override
    public short getDefaultRowHeight() {
        return this._sheet.getDefaultRowHeight();
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return (float)this._sheet.getDefaultRowHeight() / 20.0f;
    }

    @Override
    public void setDefaultRowHeight(short height) {
        this._sheet.setDefaultRowHeight(height);
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        this._sheet.setDefaultRowHeight((short)(height * 20.0f));
    }

    @Override
    public HSSFCellStyle getColumnStyle(int column) {
        short styleIndex = this._sheet.getXFIndexForColAt((short)column);
        if (styleIndex == 15) {
            return null;
        }
        ExtendedFormatRecord xf = this._book.getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this._book);
    }

    public boolean isGridsPrinted() {
        return this._sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean value) {
        this._sheet.setGridsPrinted(value);
    }

    public int addMergedRegion(org.apache.poi.ss.util.Region region) {
        return this._sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        region.validate(SpreadsheetVersion.EXCEL97);
        this.validateArrayFormulas(region);
        return this._sheet.addMergedRegion(region.getFirstRow(), region.getFirstColumn(), region.getLastRow(), region.getLastColumn());
    }

    private void validateArrayFormulas(CellRangeAddress region) {
        int firstRow = region.getFirstRow();
        int firstColumn = region.getFirstColumn();
        int lastRow = region.getLastRow();
        int lastColumn = region.getLastColumn();
        for (int rowIn = firstRow; rowIn <= lastRow; ++rowIn) {
            for (int colIn = firstColumn; colIn <= lastColumn; ++colIn) {
                CellRangeAddress arrayRange;
                HSSFCell cell;
                HSSFRow row = this.getRow(rowIn);
                if (row == null || (cell = row.getCell(colIn)) == null || !cell.isPartOfArrayFormulaGroup() || (arrayRange = cell.getArrayFormulaRange()).getNumberOfCells() <= 1 || !arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()) && !arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn())) continue;
                String msg = "The range " + region.formatAsString() + " intersects with a multi-cell array formula. " + "You cannot merge cells of an array.";
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        this._sheet.setUncalced(value);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        return this._sheet.getUncalced();
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        this._sheet.getPageSettings().getVCenter().setVCenter(value);
    }

    public boolean getVerticallyCenter(boolean value) {
        return this.getVerticallyCenter();
    }

    @Override
    public boolean getVerticallyCenter() {
        return this._sheet.getPageSettings().getVCenter().getVCenter();
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        this._sheet.getPageSettings().getHCenter().setHCenter(value);
    }

    @Override
    public boolean getHorizontallyCenter() {
        return this._sheet.getPageSettings().getHCenter().getHCenter();
    }

    @Override
    public void setRightToLeft(boolean value) {
        this._sheet.getWindowTwo().setArabic(value);
    }

    @Override
    public boolean isRightToLeft() {
        return this._sheet.getWindowTwo().getArabic();
    }

    @Override
    public void removeMergedRegion(int index) {
        this._sheet.removeMergedRegion(index);
    }

    @Override
    public int getNumMergedRegions() {
        return this._sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int index) {
        CellRangeAddress cra = this.getMergedRegion(index);
        return new Region(cra.getFirstRow(), (short)cra.getFirstColumn(), cra.getLastRow(), (short)cra.getLastColumn());
    }

    @Override
    public CellRangeAddress getMergedRegion(int index) {
        return this._sheet.getMergedRegionAt(index);
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this._rows.values().iterator();
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    InternalSheet getSheet() {
        return this._sheet;
    }

    public void setAlternativeExpression(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAlternateExpression(b);
    }

    public void setAlternativeFormula(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAlternateFormula(b);
    }

    @Override
    public void setAutobreaks(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAutobreaks(b);
    }

    public void setDialog(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setDialog(b);
    }

    @Override
    public void setDisplayGuts(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setDisplayGuts(b);
    }

    @Override
    public void setFitToPage(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setFitToPage(b);
    }

    @Override
    public void setRowSumsBelow(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setRowSumsBelow(b);
        record.setAlternateExpression(b);
    }

    @Override
    public void setRowSumsRight(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setRowSumsRight(b);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    @Override
    public boolean getAutobreaks() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    @Override
    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    @Override
    public boolean isDisplayZeros() {
        return this._sheet.getWindowTwo().getDisplayZeros();
    }

    @Override
    public void setDisplayZeros(boolean value) {
        this._sheet.getWindowTwo().setDisplayZeros(value);
    }

    @Override
    public boolean getFitToPage() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    @Override
    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    @Override
    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    @Override
    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    @Override
    public void setPrintGridlines(boolean newPrintGridlines) {
        this.getSheet().getPrintGridlines().setPrintGridlines(newPrintGridlines);
    }

    @Override
    public HSSFPrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this._sheet.getPageSettings().getPrintSetup());
    }

    @Override
    public HSSFHeader getHeader() {
        return new HSSFHeader(this._sheet.getPageSettings());
    }

    @Override
    public HSSFFooter getFooter() {
        return new HSSFFooter(this._sheet.getPageSettings());
    }

    @Override
    public boolean isSelected() {
        return this.getSheet().getWindowTwo().getSelected();
    }

    @Override
    public void setSelected(boolean sel) {
        this.getSheet().getWindowTwo().setSelected(sel);
    }

    public boolean isActive() {
        return this.getSheet().getWindowTwo().isActive();
    }

    public void setActive(boolean sel) {
        this.getSheet().getWindowTwo().setActive(sel);
    }

    @Override
    public double getMargin(short margin) {
        switch (margin) {
            case 5: {
                return this._sheet.getPageSettings().getPrintSetup().getFooterMargin();
            }
            case 4: {
                return this._sheet.getPageSettings().getPrintSetup().getHeaderMargin();
            }
        }
        return this._sheet.getPageSettings().getMargin(margin);
    }

    @Override
    public void setMargin(short margin, double size) {
        switch (margin) {
            case 5: {
                this._sheet.getPageSettings().getPrintSetup().setFooterMargin(size);
                break;
            }
            case 4: {
                this._sheet.getPageSettings().getPrintSetup().setHeaderMargin(size);
                break;
            }
            default: {
                this._sheet.getPageSettings().setMargin(margin, size);
            }
        }
    }

    private WorksheetProtectionBlock getProtectionBlock() {
        return this._sheet.getProtectionBlock();
    }

    @Override
    public boolean getProtect() {
        return this.getProtectionBlock().isSheetProtected();
    }

    public short getPassword() {
        return (short)this.getProtectionBlock().getPasswordHash();
    }

    public boolean getObjectProtect() {
        return this.getProtectionBlock().isObjectProtected();
    }

    @Override
    public boolean getScenarioProtect() {
        return this.getProtectionBlock().isScenarioProtected();
    }

    @Override
    public void protectSheet(String password) {
        this.getProtectionBlock().protectSheet(password, true, true);
    }

    @Override
    public void setZoom(int numerator, int denominator) {
        if (numerator < 1 || numerator > 65535) {
            throw new IllegalArgumentException("Numerator must be greater than 1 and less than 65536");
        }
        if (denominator < 1 || denominator > 65535) {
            throw new IllegalArgumentException("Denominator must be greater than 1 and less than 65536");
        }
        SCLRecord sclRecord = new SCLRecord();
        sclRecord.setNumerator((short)numerator);
        sclRecord.setDenominator((short)denominator);
        this.getSheet().setSCLRecord(sclRecord);
    }

    @Override
    public short getTopRow() {
        return this._sheet.getTopRow();
    }

    @Override
    public short getLeftCol() {
        return this._sheet.getLeftCol();
    }

    @Override
    public void showInPane(short toprow, short leftcol) {
        this._sheet.setTopRow(toprow);
        this._sheet.setLeftCol(leftcol);
    }

    protected void shiftMerged(int startRow, int endRow, int n, boolean isRow) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < this.getNumMergedRegions(); ++i) {
            boolean inEnd;
            CellRangeAddress merged = this.getMergedRegion(i);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || SheetUtil.containsCell(merged, startRow - 1, 0) || SheetUtil.containsCell(merged, endRow + 1, 0)) continue;
            merged.setFirstRow(merged.getFirstRow() + n);
            merged.setLastRow(merged.getLastRow() + n);
            shiftedRegions.add(merged);
            this.removeMergedRegion(i);
            --i;
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.addMergedRegion(region);
        }
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        this.shiftRows(startRow, endRow, n, copyRowHeight, resetOriginalRowHeight, true);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight, boolean moveComments) {
        block18: {
            int i;
            block17: {
                int inc;
                int s;
                if (n < 0) {
                    s = startRow;
                    inc = 1;
                } else if (n > 0) {
                    s = endRow;
                    inc = -1;
                } else {
                    return;
                }
                NoteRecord[] noteRecs = moveComments ? this._sheet.getNoteRecords() : NoteRecord.EMPTY_ARRAY;
                this.shiftMerged(startRow, endRow, n, true);
                this._sheet.getPageSettings().shiftRowBreaks(startRow, endRow, n);
                for (int rowNum = s; rowNum >= startRow && rowNum <= endRow && rowNum >= 0 && rowNum < 65536; rowNum += inc) {
                    HSSFRow row2Replace;
                    HSSFRow row = this.getRow(rowNum);
                    if (row != null) {
                        this.notifyRowShifting(row);
                    }
                    if ((row2Replace = this.getRow(rowNum + n)) == null) {
                        row2Replace = this.createRow(rowNum + n);
                    }
                    row2Replace.removeAllCells();
                    if (row == null) continue;
                    if (copyRowHeight) {
                        row2Replace.setHeight(row.getHeight());
                    }
                    if (resetOriginalRowHeight) {
                        row.setHeight((short)255);
                    }
                    Iterator<Cell> cells = row.cellIterator();
                    while (cells.hasNext()) {
                        HSSFCell cell = (HSSFCell)cells.next();
                        row.removeCell(cell);
                        CellValueRecordInterface cellRecord = cell.getCellValueRecord();
                        cellRecord.setRow(rowNum + n);
                        row2Replace.createCellFromRecord(cellRecord);
                        this._sheet.addValueRecord(rowNum + n, cellRecord);
                        HSSFHyperlink link = cell.getHyperlink();
                        if (link == null) continue;
                        link.setFirstRow(link.getFirstRow() + n);
                        link.setLastRow(link.getLastRow() + n);
                    }
                    row.removeAllCells();
                    if (!moveComments) continue;
                    for (int i2 = noteRecs.length - 1; i2 >= 0; --i2) {
                        HSSFComment comment;
                        NoteRecord nr = noteRecs[i2];
                        if (nr.getRow() != rowNum || (comment = this.getCellComment(rowNum, nr.getColumn())) == null) continue;
                        comment.setRow(rowNum + n);
                    }
                }
                if (n <= 0) break block17;
                if (startRow == this._firstrow) {
                    this._firstrow = Math.max(startRow + n, 0);
                    for (i = startRow + 1; i < startRow + n; ++i) {
                        if (this.getRow(i) == null) continue;
                        this._firstrow = i;
                        break;
                    }
                }
                if (endRow + n <= this._lastrow) break block18;
                this._lastrow = Math.min(endRow + n, SpreadsheetVersion.EXCEL97.getLastRowIndex());
                break block18;
            }
            if (startRow + n < this._firstrow) {
                this._firstrow = Math.max(startRow + n, 0);
            }
            if (endRow == this._lastrow) {
                this._lastrow = Math.min(endRow + n, SpreadsheetVersion.EXCEL97.getLastRowIndex());
                for (i = endRow - 1; i > endRow + n; ++i) {
                    if (this.getRow(i) == null) continue;
                    this._lastrow = i;
                    break;
                }
            }
        }
        int sheetIndex = this._workbook.getSheetIndex(this);
        short externSheetIndex = this._book.checkExternSheet(sheetIndex);
        FormulaShifter shifter = FormulaShifter.createForRowShift(externSheetIndex, startRow, endRow, n);
        this._sheet.updateFormulasAfterCellShift(shifter, externSheetIndex);
        int nSheets = this._workbook.getNumberOfSheets();
        for (int i = 0; i < nSheets; ++i) {
            InternalSheet otherSheet = this._workbook.getSheetAt(i).getSheet();
            if (otherSheet == this._sheet) continue;
            short otherExtSheetIx = this._book.checkExternSheet(i);
            otherSheet.updateFormulasAfterCellShift(shifter, otherExtSheetIx);
        }
        this._workbook.getWorkbook().updateNamesAfterCellShift(shifter);
    }

    protected void insertChartRecords(List<Record> records) {
        int window2Loc = this._sheet.findFirstRecordLocBySid((short)574);
        this._sheet.getRecords().addAll(window2Loc, records);
    }

    private void notifyRowShifting(HSSFRow row) {
        String msg = "Row[rownum=" + row.getRowNum() + "] contains cell(s) included in a multi-cell array formula. " + "You cannot change part of an array.";
        for (Cell cell : row) {
            HSSFCell hcell = (HSSFCell)cell;
            if (!hcell.isPartOfArrayFormulaGroup()) continue;
            hcell.notifyArrayFormulaChanging(msg);
        }
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this.validateColumn(colSplit);
        this.validateRow(rowSplit);
        if (leftmostColumn < colSplit) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (topRow < rowSplit) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(colSplit, rowSplit, topRow, leftmostColumn);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.getSheet().createSplitPane(xSplitPos, ySplitPos, topRow, leftmostColumn, activePane);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        this._sheet.setDisplayGridlines(show);
    }

    @Override
    public boolean isDisplayGridlines() {
        return this._sheet.isDisplayGridlines();
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        this._sheet.setDisplayFormulas(show);
    }

    @Override
    public boolean isDisplayFormulas() {
        return this._sheet.isDisplayFormulas();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        this._sheet.setDisplayRowColHeadings(show);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this._sheet.isDisplayRowColHeadings();
    }

    @Override
    public void setRowBreak(int row) {
        this.validateRow(row);
        this._sheet.getPageSettings().setRowBreak(row, (short)0, (short)255);
    }

    @Override
    public boolean isRowBroken(int row) {
        return this._sheet.getPageSettings().isRowBroken(row);
    }

    @Override
    public void removeRowBreak(int row) {
        this._sheet.getPageSettings().removeRowBreak(row);
    }

    @Override
    public int[] getRowBreaks() {
        return this._sheet.getPageSettings().getRowBreaks();
    }

    @Override
    public int[] getColumnBreaks() {
        return this._sheet.getPageSettings().getColumnBreaks();
    }

    @Override
    public void setColumnBreak(int column) {
        this.validateColumn((short)column);
        this._sheet.getPageSettings().setColumnBreak((short)column, (short)0, (short)SpreadsheetVersion.EXCEL97.getLastRowIndex());
    }

    @Override
    public boolean isColumnBroken(int column) {
        return this._sheet.getPageSettings().isColumnBroken(column);
    }

    @Override
    public void removeColumnBreak(int column) {
        this._sheet.getPageSettings().removeColumnBreak(column);
    }

    protected void validateRow(int row) {
        int maxrow = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (row > maxrow) {
            throw new IllegalArgumentException("Maximum row number is " + maxrow);
        }
        if (row < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(int column) {
        int maxcol = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        if (column > maxcol) {
            throw new IllegalArgumentException("Maximum column number is " + maxcol);
        }
        if (column < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean fat) {
        this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        EscherAggregate r = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List<EscherRecord> escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        for (EscherRecord escherRecord : escherRecords) {
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    @Override
    public HSSFPatriarch createDrawingPatriarch() {
        if (this._patriarch == null) {
            this._workbook.initDrawings();
            if (this._patriarch == null) {
                this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), true);
                EscherAggregate agg = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
                this._patriarch = new HSSFPatriarch(this, agg);
                agg.setPatriarch(this._patriarch);
            }
        }
        return this._patriarch;
    }

    public EscherAggregate getDrawingEscherAggregate() {
        this._book.findDrawingGroup();
        if (this._book.getDrawingManager() == null) {
            return null;
        }
        int found = this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        if (found == -1) {
            return null;
        }
        EscherAggregate agg = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
        return agg;
    }

    public HSSFPatriarch getDrawingPatriarch() {
        if (this._patriarch != null) {
            return this._patriarch;
        }
        EscherAggregate agg = this.getDrawingEscherAggregate();
        if (agg == null) {
            return null;
        }
        this._patriarch = new HSSFPatriarch(this, agg);
        agg.setPatriarch(this._patriarch);
        agg.convertRecordsToUserModel();
        return this._patriarch;
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        this.setColumnGroupCollapsed(columnNumber & 0xFFFF, collapsed);
    }

    public void groupColumn(short fromColumn, short toColumn) {
        this.groupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    public void ungroupColumn(short fromColumn, short toColumn) {
        this.ungroupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this._sheet.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        this._sheet.groupColumnRange(fromColumn, toColumn, true);
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        this._sheet.groupColumnRange(fromColumn, toColumn, false);
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        this._sheet.groupRowRange(fromRow, toRow, true);
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        this._sheet.groupRowRange(fromRow, toRow, false);
    }

    @Override
    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this._sheet.getRowsAggregate().collapseRow(rowIndex);
        } else {
            this._sheet.getRowsAggregate().expandRow(rowIndex);
        }
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        this._sheet.setDefaultColumnStyle(column, ((HSSFCellStyle)style).getIndex());
    }

    @Override
    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = SheetUtil.getColumnWidth(this, column, useMergedCells);
        if (width != -1.0) {
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(column, (int)width);
        }
    }

    @Override
    public HSSFComment getCellComment(int row, int column) {
        HSSFRow r = this.getRow(row);
        if (r != null) {
            HSSFCell c = r.getCell(column);
            if (c != null) {
                return c.getCellComment();
            }
            return HSSFCell.findCellComment(this._sheet, row, column);
        }
        return null;
    }

    @Override
    public HSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new HSSFSheetConditionalFormatting(this);
    }

    @Override
    public String getSheetName() {
        HSSFWorkbook wb = this.getWorkbook();
        int idx = wb.getSheetIndex(this);
        return wb.getSheetName(idx);
    }

    private CellRange<HSSFCell> getCellRange(CellRangeAddress range) {
        int firstRow = range.getFirstRow();
        int firstColumn = range.getFirstColumn();
        int lastRow = range.getLastRow();
        int lastColumn = range.getLastColumn();
        int height = lastRow - firstRow + 1;
        int width = lastColumn - firstColumn + 1;
        ArrayList<HSSFCell> temp = new ArrayList<HSSFCell>(height * width);
        for (int rowIn = firstRow; rowIn <= lastRow; ++rowIn) {
            for (int colIn = firstColumn; colIn <= lastColumn; ++colIn) {
                HSSFCell cell;
                HSSFRow row = this.getRow(rowIn);
                if (row == null) {
                    row = this.createRow(rowIn);
                }
                if ((cell = row.getCell(colIn)) == null) {
                    cell = row.createCell(colIn);
                }
                temp.add(cell);
            }
        }
        return SSCellRange.create(firstRow, firstColumn, height, width, temp, HSSFCell.class);
    }

    public CellRange<HSSFCell> setArrayFormula(String formula, CellRangeAddress range) {
        int sheetIndex = this._workbook.getSheetIndex(this);
        Ptg[] ptgs = HSSFFormulaParser.parse(formula, this._workbook, 2, sheetIndex);
        CellRange<HSSFCell> cells = this.getCellRange(range);
        for (HSSFCell c : cells) {
            c.setCellArrayFormula(range);
        }
        HSSFCell mainArrayFormulaCell = cells.getTopLeftCell();
        FormulaRecordAggregate agg = (FormulaRecordAggregate)mainArrayFormulaCell.getCellValueRecord();
        agg.setArrayFormula(range, ptgs);
        return cells;
    }

    public CellRange<HSSFCell> removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        CellValueRecordInterface rec = ((HSSFCell)cell).getCellValueRecord();
        if (!(rec instanceof FormulaRecordAggregate)) {
            String ref = new CellReference(cell).formatAsString();
            throw new IllegalArgumentException("Cell " + ref + " is not part of an array formula.");
        }
        FormulaRecordAggregate fra = (FormulaRecordAggregate)rec;
        CellRangeAddress range = fra.removeArrayFormula(cell.getRowIndex(), cell.getColumnIndex());
        CellRange<HSSFCell> result = this.getCellRange(range);
        for (HSSFCell c : result) {
            c.setCellType(3);
        }
        return result;
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return new HSSFDataValidationHelper(this);
    }

    @Override
    public HSSFAutoFilter setAutoFilter(CellRangeAddress range) {
        int sheetIndex;
        InternalWorkbook workbook = this._workbook.getWorkbook();
        NameRecord name = workbook.getSpecificBuiltinRecord((byte)13, (sheetIndex = this._workbook.getSheetIndex(this)) + 1);
        if (name == null) {
            name = workbook.createBuiltInName((byte)13, sheetIndex + 1);
        }
        Area3DPtg ptg = new Area3DPtg(range.getFirstRow(), range.getLastRow(), range.getFirstColumn(), range.getLastColumn(), false, false, false, false, sheetIndex);
        name.setNameDefinition(new Ptg[]{ptg});
        AutoFilterInfoRecord r = new AutoFilterInfoRecord();
        int numcols = 1 + range.getLastColumn() - range.getFirstColumn();
        r.setNumEntries((short)numcols);
        int idx = this._sheet.findFirstRecordLocBySid((short)512);
        this._sheet.getRecords().add(idx, r);
        HSSFPatriarch p = this.createDrawingPatriarch();
        for (int col = range.getFirstColumn(); col <= range.getLastColumn(); ++col) {
            p.createComboBox(new HSSFClientAnchor(0, 0, 0, 0, (short)col, range.getFirstRow(), (short)(col + 1), range.getFirstRow() + 1));
        }
        return new HSSFAutoFilter(this);
    }
}

