/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;

public class HCellStyle
extends Common
implements CellStyle {
    private final HSSFWorkbook workbook;
    private final HSSFCellStyle cellStyle;

    public HCellStyle(HSSFWorkbook workbook, HSSFCellStyle cellStyle) {
        this.workbook = workbook;
        this.cellStyle = cellStyle;
    }

    public void setBorderBottom(BorderStyle border) {
        this.cellStyle.setBorderBottom(border);
    }

    public void setBorderLeft(BorderStyle border) {
        this.cellStyle.setBorderLeft(border);
    }

    public void setBorderRight(BorderStyle border) {
        this.cellStyle.setBorderRight(border);
    }

    public void setBorderTop(BorderStyle border) {
        this.cellStyle.setBorderTop(border);
    }

    public void setBottomBorderColor(short color) {
        this.cellStyle.setBottomBorderColor(color);
    }

    public void setLeftBorderColor(short color) {
        this.cellStyle.setLeftBorderColor(color);
    }

    public void setRightBorderColor(short color) {
        this.cellStyle.setRightBorderColor(color);
    }

    public void setTopBorderColor(short color) {
        this.cellStyle.setTopBorderColor(color);
    }

    public void setDataFormat(String format) {
        HSSFDataFormat dataFormat = this.workbook.createDataFormat();
        this.cellStyle.setDataFormat(dataFormat.getFormat(format));
    }

    public void setFillBackgroundColor(short bg) {
        this.cellStyle.setFillBackgroundColor(bg);
    }

    public void setFillForegroundColor(short fp) {
        this.cellStyle.setFillForegroundColor(fp);
    }

    public void setFillPattern(FillPatternType bg) {
        this.cellStyle.setFillPattern(bg);
    }

    public void setWrapText(boolean wrap) {
        this.cellStyle.setWrapText(wrap);
    }

    public static HCellStyle create(HSSFWorkbook workbook, String name) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        if (name != null) {
            cellStyle.setUserStyleName(name);
        }
        return new HCellStyle(workbook, cellStyle);
    }

    public static HCellStyle get(HSSFWorkbook workbook, String name) {
        for (int i = 0; i < workbook.getNumCellStyles(); i = (int)((short)(i + 1))) {
            HSSFCellStyle cs = workbook.getCellStyleAt(i);
            String userStyleName = cs.getUserStyleName();
            if (userStyleName == null || !cs.getUserStyleName().equals(name)) continue;
            return new HCellStyle(workbook, cs);
        }
        return null;
    }

    public static void set(HSSFCell c, HCellStyle cs) {
        c.setCellStyle(cs.cellStyle);
    }
}

