/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

public class ThemesTable
extends POIXMLDocumentPart {
    private ThemeDocument theme;

    public ThemesTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        try {
            this.theme = ThemeDocument.Factory.parse((InputStream)part.getInputStream());
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public ThemesTable(ThemeDocument theme) {
        this.theme = theme;
    }

    public XSSFColor getThemeColor(int idx) {
        CTColor ctColor;
        CTColorScheme colorScheme = this.theme.getTheme().getThemeElements().getClrScheme();
        switch (idx) {
            case 0: {
                ctColor = colorScheme.getLt1();
                break;
            }
            case 1: {
                ctColor = colorScheme.getDk1();
                break;
            }
            case 2: {
                ctColor = colorScheme.getLt2();
                break;
            }
            case 3: {
                ctColor = colorScheme.getDk2();
                break;
            }
            case 4: {
                ctColor = colorScheme.getAccent1();
                break;
            }
            case 5: {
                ctColor = colorScheme.getAccent2();
                break;
            }
            case 6: {
                ctColor = colorScheme.getAccent3();
                break;
            }
            case 7: {
                ctColor = colorScheme.getAccent4();
                break;
            }
            case 8: {
                ctColor = colorScheme.getAccent5();
                break;
            }
            case 9: {
                ctColor = colorScheme.getAccent6();
                break;
            }
            case 10: {
                ctColor = colorScheme.getHlink();
                break;
            }
            case 11: {
                ctColor = colorScheme.getFolHlink();
                break;
            }
            default: {
                return null;
            }
        }
        byte[] rgb = null;
        if (ctColor.isSetSrgbClr()) {
            rgb = ctColor.getSrgbClr().getVal();
        } else if (ctColor.isSetSysClr()) {
            rgb = ctColor.getSysClr().getLastClr();
        } else {
            return null;
        }
        return new XSSFColor(rgb);
    }

    public void inheritFromThemeAsRequired(XSSFColor color) {
        if (color == null) {
            return;
        }
        if (!color.getCTColor().isSetTheme()) {
            return;
        }
        XSSFColor themeColor = this.getThemeColor(color.getTheme());
        color.getCTColor().setRgb(themeColor.getCTColor().getRgb());
    }
}

