% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wasserstein_distance.R
\name{wasserstein}
\alias{wasserstein}
\title{Calculate Wasserstein distances}
\usage{
wasserstein(
  X,
  Y,
  p = 2,
  ground_p = 2,
  observation.orientation = c("rowwise", "colwise"),
  method = c("exact", "sinkhorn", "greenkhorn", "hilbert", "rank",
    "univariate.approximation", "univariate.approximation.pwr", "univariate"),
  ...
)
}
\arguments{
\item{X}{Matrix for first group}

\item{Y}{Matrix for second group}

\item{p}{Power of the Wasserstein distance}

\item{ground_p}{Power of the distance metric. Usually same as \code{p}}

\item{observation.orientation}{Are observations unique by rows or columns? One of "colwise" or "rowwise"}

\item{method}{One of the outputs of \code{\link[=transport_options]{transport_options()}}}

\item{...}{additional options for sinkhorn based methods. \code{epsilon} and \code{niter} determining the hyperparameters for the negative entropy penalty}
}
\value{
A numeric value
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function will calculate exact or approximate Wasserstein distances between two groups of observations. Please note that this function will likely be deprecated in favor of using the native function from the \code{approxOT} package.
}
\examples{
if(rlang::is_installed("stats")) {
n <- 128
p <- 10
x <- matrix( stats::rnorm( p * n ), nrow = n, ncol = p )
y <- matrix( stats::rnorm( p * n ), nrow = n, ncol = p )

dist <- wasserstein(x,y, p = 2, ground_p = 1, observation.orientation = "rowwise",
            method = "hilbert") #fast
print(dist)
}
}
