% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{computeConsumerSurplus}
\alias{computeConsumerSurplus}
\title{Computes the expected cumulative consumer surplus}
\usage{
computeConsumerSurplus(campaign, price)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}

\item{price}{Price as number in [0; 1] where 0 is the minimal and 1 is the maximal price.}
}
\value{
Expected cumulative consumer surplus.
}
\description{
Computes the expected cumulative consumer surplus for a given Word-of-Mouth campaign at a given price.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
surplus <- computeConsumerSurplus(campaign, price = 0.5)
print(surplus)

}
\seealso{
\code{\link{computeDemand}} \code{\link{computeProfit}} \code{\link{computeOptimalPrice}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
