% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_simulation.r
\name{simulate_conditionally}
\alias{simulate_conditionally}
\title{Add simulated values to a dataset conditionally, based on a \code{simbase_*} object}
\usage{
simulate_conditionally(data, simbase, force_positive = TRUE, ...)
}
\arguments{
\item{data}{The dataset where simulated values are added to.
The dataset has to contain at least one variable which is also included in
the \code{simbase_*} object.}

\item{simbase}{Basic data object for the simulation, as calculated e.g.
by \code{\link{simbase_covar}} or \code{\link{simbase_list}}.}

\item{force_positive}{If \code{TRUE}, the resulting values are forced
to be \eqn{\ge 0}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The modified dataset \code{data} with simulated values.
}
\description{
Add simulated values to a dataset conditionally, based on a \code{simbase_*} object
}
\details{
Given a \code{simbase_*} object, this function adds simulated values to a
dataset, conditional on the values of some of the variables already
contained in the dataset.
}
\examples{
# add simulated tension data based on a simbase stored in WoodSimulatR
dataset <- data.frame(E_dyn = rnorm(n = 100, mean = 12500, sd = 2200));
dataset_t <- simulate_conditionally(dataset, ws_t)

# add simulated bending data
dataset_be <- simulate_conditionally(dataset, ws_be)

}
