% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{list_properties}
\alias{list_properties}
\title{List properties of a Wikidata item}
\usage{
list_properties(item, names = FALSE)
}
\arguments{
\item{item}{a list of one or more Wikidata items returned with
\code{\link{get_item}}.}

\item{names}{a boolian for whether to return property names, or just P numbers
and extract.}
}
\value{
a list containing one sub-list for each entry in \code{items},
and (below that) the found data for each claim. In the event a claim
cannot be found for an item, an \code{NA} will be returned
instead.
}
\description{
for a downloaded wikidata item, list the properties of all statements
}
\examples{
# Get item data
adams_data <- get_item("42")
# Get claim data
claims <- extract_claims(adams_data, "P31")
}
