% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tokens.R
\name{plot_tokens}
\alias{plot_tokens}
\title{Visualizing token distribution per person}
\usage{
plot_tokens(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = as.character(as.POSIXct(Sys.time(), tz = "UTC")),
  plot = "bar",
  return_data = FALSE,
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chatlog that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{plot}{The type of plot to be used. Options include "bar","box","violin" and "cumsum". Default is "bar".}

\item{return_data}{If TRUE, returns the subsetted data frame. Default is FALSE.}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' System Messages from the descriptive statistics. Default is FALSE.}
}
\value{
Plots showcasing the distribution of tokens per person
}
\description{
Visualizing token distribution per person
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_tokens(data)
}
