% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_replytimes.R
\name{plot_replytimes}
\alias{plot_replytimes}
\title{Visualizing replytimes in 'WhatsApp' chat logs}
\usage{
plot_replytimes(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = "2200-01-01 00:00",
  return_data = FALSE,
  aggregate_sessions = TRUE,
  plot = "box",
  type = "replytime",
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chat log that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[base]{as.POSIXct}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[base]{as.POSIXct}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{return_data}{If TRUE, returns a data frame of response times extracted from the chat for more elaborate plotting. Default is FALSE.}

\item{aggregate_sessions}{If TRUE, concurrent messages of the same author are aggregated into one session. Default is TRUE.}

\item{plot}{Type of plot to be returned, options are "box" and "heatmap".}

\item{type}{If "replytime", plots display how much time it takes authors to reply to previous message, if "reactiontime", plots display how much time it takes for authors to get responded to.}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from the data. Default is FALSE.}
}
\value{
Plots for Replytimes or Reactiontimes of authors. Input will be ordered by TimeOrder column.
}
\description{
Visualizes the reply times and reaction times to messages per author
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_replytimes(data)
}
