% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_messages.R
\name{plot_messages}
\alias{plot_messages}
\title{Visualizing the number of sent messages per person in 'WhatsApp' chat logs}
\usage{
plot_messages(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = "2200-01-01 00:00",
  plot = "bar",
  return_data = FALSE,
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chat log that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{plot}{Type of plot to be returned, options are "bar", "cumsum", "heatmap" and "pie". Default is "bar".}

\item{return_data}{If TRUE, returns the subset data frame. Default is FALSE.}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from the descriptive statistics. Default is FALSE.}
}
\value{
Plots summarizing the number of messages per person
}
\description{
Plots summarizing the amount of messages per person
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_messages(data)

}
