\name{LRbounds}
\alias{LRbounds}

\title{Likelihood Ratio bounds}

\description{
 Generates bounds across a double-sided confidence interval based on a likelihood ratio contour.}

\usage{
LRbounds(x,  dist="weibull", CL=0.9, unrel=NULL,  contour=NULL, dof=1,
                ptDensity=120, debias="none", show=FALSE)
}

\arguments{
  \item{x}{A dataframe such as generated by mleframe with column names 'left', 'right' and optionally 'qty'.
    Exact failure data (occurrences) have same time entered in both 'left' and 'right' columns.
	Suspension data has last known life[time] entered in 'left' column and -1 entered in 'right' column.
	The left(early) interval bound for left-censored data must be entered as zero. (NA is not accepted).
  }
  \item{dist}{A string defining a distribution to be fit. Implemented distributions are "weibull" (default) and "lognormal".
  (Only 2-parameter models are accepted.)
  }
  \item{CL}{A scalar for the double-sided confidence interval of interest. Default = 0.9, for 90% double-sided bounds.
  }
  \item{unrel}{An optional vector of unreliability values to be used as the descriptive quantiles at which the bounds will be calculated.
  }
  \item{contour}{An optional dataframe object previously generated by MLEcontour on x, consistent with CL and dist.
  }
  \item{dof}{An integer value indicating degrees of freedom to apply to the Chi square test, which defaults to dof=1 for
  confidence interval bound use. Should be set to 2 for comparison of two models each with 2 parameters.
  }
  \item{ptDensity}{an integer value for the number of points to be plotted around the circumference of the contour.}
  \item{debias}{A place holder for an optional string argument indicating the adjustment to be applied to the shape or standard deviation
  parameter of the fitted data. NOT YET IMPLEMEMENTED - see details.
  }
   \item{show}{A logical determining whether a crude graphic of the bounds shall be displayed.
  } 
}

\value{
  Returns a dataframe holding values of percentiles, lower, datum, and upper values of the bound.
}

\details{
  An "observed" information matrix is derived numerically as the hessian by means of optimHess.  From the variance-covariance matrix (inverse of the hessian) variation of life(-time) at given quantiles is determined.
  
  Some commercial softwares apply a modification of the LR bounds based on the application of a bias adjustment. Abernethy's "Justified Likelihood Function" has not been demonstrated to be academically accepted, so no attempt has been made to implement similar modification.
  Contribution of evidence or a method contrary to this position will gladly be reviewed by the package maintainer.
}

\references{
  William Q. Meeker and Luis A. Escobar, (1998) "Statistical Methods for Reliability Data", Wiley-Interscience, New York
  
  Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition"
  
  John I. McCool, (2012) "Using the Weibull Distribution: Reliability, Modeling and Inference"
}

\examples{
set.seed(4321)
data<-rlnorm(30,2,1.2)
bounds<-LRbounds(mleframe(data[7:30],data[1:6]), dist="lognormal")
}

\keyword{ regression reliability }