% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.anova}
\alias{wp.anova}
\title{Statistical Power Analysis for One-way ANOVA}
\usage{
wp.anova(k = NULL, n = NULL, f = NULL, alpha = 0.05, power = NULL,
  type = c("overall", "two.sided", "greater", "less"))
}
\arguments{
\item{k}{Number of groups.}

\item{n}{Sample size.}

\item{f}{Effect size. We use the statistic f as the measure of effect size for one-way ANOVA as in \cite{Cohen (1988)}. Cohen defined the size of effect as: small 0.1, medium 0.25, and large 0.4.}

\item{alpha}{Significance level chosed for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}

\item{type}{Type of test (\code{"overall"} or \code{"two.sided"} or \code{"greater"} or \code{"less"}). The default is "two.sided".
The option "overall" is for the overall test of anova; "two.sided" is for a contrast anova; "greater" is testing the between-group vairance greater than the within-group, while "less" is vis versus.}
}
\value{
An object of the power analysis.
}
\description{
One-way analysis of variance (one-way ANOVA) is a technique used to compare means of two or more groups (e.g., \cite{Maxwell & Delaney, 2003}).
The ANOVA tests the null hypothesis that samples in two or more groups are drawn from populations with the same mean values.
The ANOVA analysis typically produces an F-statistic, the ratio of the bewteen-group variance to the within-group variance.
}
\examples{
#To calculate the statistical power for the overall test of one-way ANOVA:
wp.anova(f=0.25,k=4, n=100, alpha=0.05)
#  Power for One-way ANOVA
#
#    k   n    f alpha     power
#    4 100 0.25  0.05 0.5181755
#
#  NOTE: n is the total sample size (overall)
#  URL: http://psychstat.org/anova

#To calculate the power curve with a sequence of sample sizes:
res <- wp.anova(f=0.25, k=4, n=seq(100,200,10), alpha=0.05)
res
#  Power for One-way ANOVA
#
#    k   n    f alpha     power
#    4 100 0.25  0.05 0.5181755
#    4 110 0.25  0.05 0.5636701
#    4 120 0.25  0.05 0.6065228
#    4 130 0.25  0.05 0.6465721
#    4 140 0.25  0.05 0.6837365
#    4 150 0.25  0.05 0.7180010
#    4 160 0.25  0.05 0.7494045
#    4 170 0.25  0.05 0.7780286
#    4 180 0.25  0.05 0.8039869
#    4 190 0.25  0.05 0.8274169
#    4 200 0.25  0.05 0.8484718
#
#  NOTE: n is the total sample size (overall)
#  URL: http://psychstat.org/anova

#To plot the power curve:
plot(res, type='b')

#To estimate the sample size with a given power:
wp.anova(f=0.25,k=4, n=NULL, alpha=0.05, power=0.8)
#  Power for One-way ANOVA
#
#    k        n    f alpha power
#    4 178.3971 0.25  0.05   0.8
#
#  NOTE: n is the total sample size (overall)
#  URL: http://psychstat.org/anova

#To estimate the minimum detectable effect size with a given power:
wp.anova(f=NULL,k=4, n=100, alpha=0.05, power=0.8)
#  Power for One-way ANOVA
#
#    k   n         f alpha power
#    4 100 0.3369881  0.05   0.8
#
#  NOTE: n is the total sample size (overall)
#  URL: http://psychstat.org/anova

#To conduct power analysis for a contrast one-way ANOVA:
wp.anova(f=0.25,k=4, n=100, alpha=0.05, type='two.sided')
#  Power for One-way ANOVA
#
#    k   n    f alpha     power
#    4 100 0.25  0.05 0.6967142
#
#  NOTE: n is the total sample size (contrast, two.sided)
#  URL: http://psychstat.org/anova

#To calculate the power curve with a sequence of sample sizes:
res <- wp.anova(f=seq(0.1, 0.8, 0.1), k=4, n=100, alpha=0.05)
res
#  Power for One-way ANOVA
#
#    k   n   f alpha     power
#    4 100 0.1  0.05 0.1128198
#    4 100 0.2  0.05 0.3452612
#    4 100 0.3  0.05 0.6915962
#    4 100 0.4  0.05 0.9235525
#    4 100 0.5  0.05 0.9911867
#    4 100 0.6  0.05 0.9995595
#    4 100 0.7  0.05 0.9999908
#    4 100 0.8  0.05 0.9999999
#
#  NOTE: n is the total sample size (overall)
#  URL: http://psychstat.org/anova
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed). Hillsdale, NJ: Lawrence Erlbaum Associates.

Maxwell, S. E., & Delaney, H. D. (2004). Designing experiments and analyzing data: A model comparison perspective (Vol. 1). Psychology Press.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
