% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.anova.count}
\alias{wp.anova.count}
\title{Statistical Power Analysis for One-way ANOVA with Count Data}
\usage{
wp.anova.count(k = NULL, n = NULL, V = NULL, alpha = 0.05,
  power = NULL)
}
\arguments{
\item{k}{Number of groups.}

\item{n}{Sample size.}

\item{V}{Effect size. See the research by \cite{Mai and Zhang (2017)} for details.}

\item{alpha}{Significance level chosed for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}
}
\value{
An object of the power analysis.
}
\description{
The power analysis procedure for one-way ANOVA with count data is introduced by \cite{Mai and Zhang (2017)}.
One-way ANOVA with count data is used for comparing means of three or more groups of binary data. Its outcome variable is supposed to follow Poisson distribution. 
And its overall test uses a likelihood ratio test statistics.
}
\examples{
\donttest{
#To calculate the statistical power for one-way ANOVA (overall test) with count data:
wp.anova.count(k=4,n=100,V=0.148,alpha=0.05)
#  One-way Analogous ANOVA with Count Data
#
#    k   n     V alpha     power
#    4 100 0.148  0.05 0.5597441
#
#  NOTE: n is the total sample size
#  URL: http://psychstat.org/anovacount

#To generate a power curve given sequence of sample sizes:
res <- wp.anova.count(k=4,n=seq(100,200,10),V=0.148,alpha=0.05,power=NULL)
res
#  One-way Analogous ANOVA with Count Data
#
#		k   n     V alpha     power
#		4 100 0.148  0.05 0.5597441
#		4 110 0.148  0.05 0.6049618
#		4 120 0.148  0.05 0.6470911
#		4 130 0.148  0.05 0.6860351
#		4 140 0.148  0.05 0.7217782
#		4 150 0.148  0.05 0.7543699
#		4 160 0.148  0.05 0.7839101
#		4 170 0.148  0.05 0.8105368
#		4 180 0.148  0.05 0.8344142
#		4 190 0.148  0.05 0.8557241
#		4 200 0.148  0.05 0.8746580
#
#  NOTE: n is the total sample size
#  URL: http://psychstat.org/anovacount

#To plot the power curve:
plot(res)

#To calculate the required sample size for one-way ANOVA (overall test) with count data:
wp.anova.count(k=4,n=NULL,V=0.148,power=0.8, alpha=0.05)
#  One-way Analogous ANOVA with Count Data
#
#    k        n     V alpha power
#    4 165.9143 0.148  0.05   0.8
#
#  NOTE: n is the total sample size
#  URL: http://psychstat.org/anovacount

#To calculate the minimum detectable effect size for one-way ANOVA (overall test) with count data:
wp.anova.count(k=4,n=100,V=NULL,power=0.8, alpha=0.05)
#  One-way Analogous ANOVA with Count Data
#
#    k   n         V alpha power
#    4 100 0.1906373  0.05   0.8
#
#  NOTE: n is the total sample size
#  URL: http://psychstat.org/anovacount

#To generate a power curve given a sequence of effect sizes:
res <- wp.anova.count(k=5,n=100,V=seq(0.1,0.5,0.05),alpha=0.05,power=NULL)
res
#  One-way Analogous ANOVA with Count Data
#
#    k   n    V alpha     power
#    5 100 0.10  0.05 0.3200744
#    5 100 0.15  0.05 0.6634861
#    5 100 0.20  0.05 0.9118531
#    5 100 0.25  0.05 0.9893643
#    5 100 0.30  0.05 0.9994549
#    5 100 0.35  0.05 0.9999887
#    5 100 0.40  0.05 0.9999999
#    5 100 0.45  0.05 1.0000000
#    5 100 0.50  0.05 1.0000000
#
#  NOTE: n is the total sample size
#  URL: http://psychstat.org/anovacount
}

}
\references{
Mai, Y., & Zhang, Z. (2017). Statistical Power Analysis for Comparing Means with Binary or Count Data Based on Analogous ANOVA. In L. A. van der Ark, M. Wiberg, S. A. Culpepper, J. A. Douglas, & W.-C. Wang (Eds.), Quantitative Psychology - The 81st Annual Meeting of the Psychometric Society, Asheville, North Carolina, 2016: Springer.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
