% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordBase.R, R/RcppExports.R
\encoding{UTF-8}
\name{validate}
\alias{validate}
\alias{validate.coords}
\alias{validate.waypoints}
\title{Validate Coords or Waypoints}
\usage{
validate(x, ...)

\method{validate}{coords}(x, ..., force = TRUE)

\method{validate}{waypoints}(x, ..., force = TRUE)
}
\arguments{
\item{x}{object of class \code{"\link{coords}"} created by function \code{\link{as_coords}()}, or
class \code{"\link{waypoints}"} created by function \code{\link{as_waypoints}()}.}

\item{...}{further arguments passed to or from other methods.}

\item{force}{\code{logical} signifying whether, if \code{TRUE}, to perform full \emph{de novo}
revalidation or, if \code{FALSE}, simply check existing \code{"valid"} attribute in the case
of a \code{"coords"} object, or \code{"validlat"} and \code{"validlon"} attributes in the case
of a \code{"waypoints"} object and only revalidate if any of these are missing; default
\code{TRUE}.}
}
\value{
\code{validate()} returns its argument with \code{logical} vector attribute \code{"valid"},
or attributes \code{"validlat"} and \code{"validlon"} updated as appropriate for
\code{"coords"} and' \code{"waypoints"} objects respectively.
}
\description{
Validate objects of class \code{"coords"} or \code{"waypoints"} as geographic locations.
}
\details{
Individual coordinate values within \code{"\link{coords}"} or \code{"\link{waypoints}"} objects
are checked to ensure they represent valid geographic locations.

To be valid, the absolute values of coordinates in degrees must not exceed 180°, or 90° if
degrees of latitude and, similarly, the absolute values of the minutes and seconds components,
where given, must not exceed 60. Otherwise, a warning will be issued and the \code{"valid"}
attribute in the case of a \code{"coords"} object, or \code{"validlat"} and \code{"validlon"}
attributes in the case of a \code{"waypoints"} object will be set to \code{FALSE} for any
non-compliant coordinate values.

Argument \code{force} is primarily intended for use by the \code{print()} methods for classes
  \code{"coords"} and \code{"waypoints"} and should otherwise left as the default value
  \code{TRUE}.
}
\examples{
## Continuing example from `as_coords()`...
\dontshow{
   dm <-
       c(5130.4659, 4932.7726, 4806.4339, 3853.3696, 0.0000, -3706.7044, -5306.2869, -2514.4093,
	   -007.6754, 1823.9137, -12246.7203, -7702.1145, 0.0000, -1217.3178, 7331.0370, -5731.1536)
   names(dm) <- 
       rep(c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
             "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"), 2)
   invisible(as_coords(dm, fmt = 2))
   latlon(dm) <- rep(c(TRUE, FALSE), each = 8)
}

## Validate "coords" object in degrees and minutes
validate(dm)

## Deliberately change the first coordinate
## to a value greater than 60 minutes
dm[1] <- 5160.4659

validate(dm)

## Examine "valid" attribute of dm
attr(dm, "valid")

###
## Continuing second example from `as_waypoints()`...
\dontshow{
   wp <- data.frame(
       lat = c(51.507765, 49.54621, 48.107232, 38.889494, 0, -37.11174, -53.104781, -25.240156),
       lon = c(-0.127924, 18.398562, -122.778671, -77.035242, 0, -12.28863, 73.517283, -57.519227)
   )
   row.names(wp) <-
       c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
         "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport")
   invisible(as_waypoints(wp))
}

## Validate "waypoints" object in decimal degrees

validate(wp)

## Deliberately change the penultimate latitude
## to an absolute value greater than 90 degrees
wp$lat[7] <- -93.104781

validate(wp)

## Examine "validlat" attribute of wp
attr(wp, "validlat")

rm(dm, wp)

}
\seealso{
\code{"\link{coords}"} and \code{"\link{waypoints}"}.

Other validate: 
\code{\link{review}()}
}
\concept{validate}
