% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_period_wavelet.R
\name{track_period_wavelet}
\alias{track_period_wavelet}
\title{Track the period of a cycle in a wavelet spectra}
\usage{
track_period_wavelet(
  wavelet = NULL,
  astro_cycle = 405,
  n.levels = 100,
  track_peaks = TRUE,
  periodlab = "Period (metres)",
  x_lab = "depth (metres)",
  palette_name = "rainbow",
  color_brewer = "grDevices",
  plot_horizontal = TRUE,
  plot_dir = TRUE,
  lowerPeriod = NULL,
  upperPeriod = NULL,
  add_lines = NULL,
  add_points = NULL,
  add_abline_h = NULL,
  add_abline_v = NULL
)
}
\arguments{
\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{astro_cycle}{Duration (in kyr) of the cycle which traced.}

\item{n.levels}{Number of color levels \code{Default=100}.}

\item{track_peaks}{Setting which indicates whether tracking is restricted
to spectral peaks (track_peaks=TRUE) or whether any point within the wavelet
spectra can be selected (track_peaks=FALSE) \code{Default=TRUE}.}

\item{periodlab}{label for the y-axis \code{Default="Period (metres)"}.}

\item{x_lab}{label for the x-axis \code{Default="depth (metres)"}.}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{plot_horizontal}{plot the wavelet horizontal or vertical eg y axis is depth or y axis power  \code{Default=TRUE}}

\item{plot_dir}{The direction of the proxy record which is assumed for tuning if time increases with increasing depth/time values
(e.g. bore hole data which gets older with increasing depth ) then plot_dir should be set to TRUE
if time decreases with depth/time values (eg stratospheric logs where 0m is the bottom of the section)
then plot_dir should be set to FALSE \code{plot_dir=TRUE}}

\item{lowerPeriod}{Lowest period value which will be plotted}

\item{upperPeriod}{Highest period value which will be plotted}

\item{add_lines}{Add  lines to the wavelet plot input should be matrix with first axis being depth/time the columns after that
should be period values  \code{Default=NULL}}

\item{add_points}{Add points to the wavelet plot input should be matrix with first axis being depth/time and columns after that
should be period values \code{Default=NULL}}

\item{add_abline_h}{Add horizontal lines to the plot. Specify the lines as a vector e.g. c(2,3,5,6)  \code{Default=NULL}}

\item{add_abline_v}{Add vertical lines to the plot. Specify the lines as a vector e.g. c(2,3,5,6)  \code{Default=NULL}}
}
\value{
Results of the tracking of a cycle in the wavelet spectra is a matrix with 3 columns.
The first column is depth/time
The second column is the period of the tracked cycle
The third column is the sedimentation rate based on the duration (in time) of the tracked cycle
}
\description{
Interactively select points in a wavelet spectra to trace a period in a wavelet spectra.
The \code{\link{track_period_wavelet}} function plots a wavelet spectra in which spectral peaks can selected
allowing one to track a ridge hence one can track the a cycle with a changing period.
Tracking points can be selected in the Interactive interface and will be shown as white dots
when one wants to deselect a point the white dots can be re-clicked/re-selected and will turn red which
indicates that the previously selected point is deselected. Deselecting points can be quite tricky
due to the close spacing of  points and such the \code{\link{delpts_tracked_period_wt}} can be used to
delete points were previously selected using the \code{\link{track_period_wavelet}} function.
}
\examples{
\donttest{
#Track the 405kyr eccentricity cycle in the magnetic susceptibility record
# of the Sullivan core of Pas et al., (2018)

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

mag_track <- track_period_wavelet(wavelet = mag_wt,
astro_cycle = 405,
n.levels = 100,
track_peaks = TRUE,
periodlab =  "Period (metres)",
x_lab = "depth (metres)",
palette_name = "rainbow",
color_brewer = "grDevices",
plot_horizontal = TRUE,
plot_dir = TRUE,
lowerPeriod = NULL,
upperPeriod = NULL,
add_lines = NULL,
add_points = NULL,
add_abline_h = NULL,
add_abline_v = NULL)
}

}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
The function is based/inspired on the \link[astrochron]{traceFreq}
function of the 'astrochron' R package
}
