% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{wpikInv}
\alias{wpikInv}
\title{Stratification matrix from inverse inclusion probabilities}
\usage{
wpikInv(X, pik, tore = FALSE, shift = FALSE, toreBound = -1)
}
\arguments{
\item{X}{matrix representing the spatial coordinates.}

\item{pik}{vector of the inclusion probabilities. The length should be equal to N.}

\item{tore}{an optional logical value, if we are considering the distance on a tore. Default is \code{FALSE}.}

\item{shift}{an optional logical value, if you would use a shift perturbation. See Details for more informations. Default is \code{FALSE}.}

\item{toreBound}{a numeric value that specify the size of the grid. Default is -1.}
}
\value{
A sparse matrix representing the spatial weights.
}
\description{
The stratification matrix is calculated from the inverse inclusion probabilities. It is a direct
implementation of the spatial weights specified in Tillé et al., (2018).
}
\details{
Entries of the stratification matrix indicates how the units are close from each others. Hence a large value \eqn{w_{kl}} means that the unit \eqn{k} 
is close to the unit \eqn{l}. This function considers that if unit \eqn{k} were selected in the sample drawn from the population then
\eqn{k} would represent \eqn{1/\pi_k} units in the population and, as a consequence, it would be natural to consider that
\eqn{k} has \eqn{n_k =  (1/\pi_k - 1)} neighbours in the population. The \eqn{n_k} neighbours are the nearest neighbours of \eqn{k} according to distances.
The weights are so calculated as follows :

\itemize{
  \item \eqn{ w_{kl} = 1} if unit \eqn{l \in N_{\lfloor n_k \rfloor }}
  \item \eqn{ w_{kl} = n_k - \lfloor n_k \rfloor} if unit \eqn{l} is the \eqn{\lceil n_k \rceil} nearest neighbour of \eqn{k}.
  \item \eqn{w_{kl} = 0} otherwise.
}


\eqn{\lfloor n_k \rfloor } and \eqn{\lceil n_k \rceil} are the inferior and the superior integers of \eqn{n_k}.

The option \code{shift} add a small normally distributed perturbation \code{rnorm(0,0.01)} to the coordinates
of the centroid of the stratum considered. This could be useful if there are many unit that have the same distances.
Indeed, if two units have the same distance and are the last unit before that the bound is reached, then the weights
of the both units is updated. If a shift perturbation is used then all the distances are differents and only one unit
weight is update such that the bound is reached. 

The shift perturbation is generated at the beginning of the procedure such that each stratum is shifted by the same perturbation.
}
\examples{

N <- 25
n <- 5
X <- as.matrix(cbind(runif(N),runif(N)))
pik <- sampling::inclusionprobabilities(runif(N),n)
W <- wpikInv(X,pik)

}
\references{
Tillé, Y., Dickson, M.M., Espa, G., and Guiliani, D. (2018). Measuring the spatial balance of a sample: A new measure based on Moran's I index.
\emph{Spatial Statistics}, 23, 182-192. \url{https://doi.org/10.1016/j.spasta.2018.02.001}
}
\seealso{
\code{\link{wpik}}, \code{\link{distUnitk}}, \code{\link{wave}}.
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
