% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShadedDensity.R
\name{ShadedDensity}
\alias{ShadedDensity}
\title{Plot the distribution of a variable with a tail shaded}
\usage{
ShadedDensity(frame, xvar, threshold, title, ..., tail = "left",
  linecolor = "darkgray", shading = "darkblue")
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the variable to be density plotted}

\item{threshold}{boundary value for the tail}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{tail}{which tail to shade, 'left' (default) or 'right'}

\item{linecolor}{color of density curve}

\item{shading}{color of shaded region and boundaries}
}
\description{
Plot the distribution of a variable with a tail shaded. Annotate with the area of the shaded region.
}
\examples{

set.seed(52523)
d = data.frame(meas=rnorm(100))
threshold = -1.5
WVPlots::ShadedDensity(d, "meas", threshold,
                       title="Example shaded density plot, left tail")
WVPlots::ShadedDensity(d, "meas", -threshold, tail="right",
                       title="Example shaded density plot, right tail")

}
\seealso{
\code{\link{ShadedDensityCenter}}
}
