% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_elevation_data.R
\name{download_elevation_data}
\alias{download_elevation_data}
\title{Download DEM from AWS Terrain Tiles}
\usage{
download_elevation_data(lon, lat, path_output)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.Can accept a vector of multiple ISO codes.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}

\item{path_output}{A character string giving the file path of an output directory to save downloaded data.}
}
\value{
Character string giving path to downloaded data.
}
\description{
This function takes the coordinates of sampling sites (longitude and latitude) and downloads a Digital Elevation Model (DEM)
for the surrounding area. The DEM has an approximate spatial resolution of 100 meters. These data are derived from the
Shuttle Radar Topography Mission (SRTM) DEM, which is accessible through the Amazon Web Services (AWS) API and the
\href{https://CRAN.R-project.org/package=elevatr}{\code{elevatr}} R package.
}
\examples{
\donttest{

download_elevation_data(lon = template_WES_data$lon,
                        lat = template_WES_data$lat,
                        path_output = tempdir())

}
}
