% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lai_inversion_lut.R
\name{lai_inversion_lut}
\alias{lai_inversion_lut}
\title{Inversion of LAI from look up table generated by WCM}
\usage{
lai_inversion_lut(img, lookuptable)
}
\arguments{
\item{img}{raster object}

\item{lookuptable}{Look up table simulated from 'wcm_sim' function}
}
\value{
a raster object (pixel value represents LAI)
}
\description{
Inversion of LAI from look up table generated by WCM
}
\examples{
radar <- raster::raster(ncol=10, nrow=10)
val <- seq(-12,-7, length.out=100)
radar[] <- val
A= -9.596695
B= -0.005331
C= -11.758309
D=  0.011344
lut <- lut_wcm(LAI=seq(1,6,0.1), SM=seq(0,.6,.01),coeff=c(A,B,C,D))
\donttest{out_lai <- lai_inversion_lut(img = radar,lookuptable = lut)}
}
