% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_plot.R
\name{plot.decomposition}
\alias{plot.decomposition}
\title{Decomposition Plot Methods}
\usage{
\method{plot}{decomposition}(x, type = c("full", "period", "classical"), legend = TRUE, ...)
}
\arguments{
\item{x}{An object of class "decomposition".}

\item{type}{A character string. One of "full","period", or "classical". If "full", the full reconstruction is plotted. If "period", the reconstruction of each period is plotted individually. If "classical", the trend and seasonality are plotted.}

\item{legend}{A Boolean specifying whether a legend should be added when type is "full". The default option is TRUE.}

\item{...}{Additional arguments.}
}
\value{
A plot of the reconstruction in the "decomposition" class object.
}
\description{
Methods for plotting objects of the class "decomposition".
}
\examples{
data("park_visitation")

park <- "YELL"
nps_ts <- ts(park_visitation[park_visitation$park == park,]$nps, start = 2005, frequency = 12)
nps_ts <- log(nps_ts)

pud_ts <- ts(park_visitation[park_visitation$park == park,]$pud, start = 2005, frequency = 12)
pud_ts <- log(pud_ts)
nps_ts <- ts(park_visitation[park_visitation$park == park,]$nps, start = 2005, frequency = 12)
nps_ts <- log(nps_ts)



decomposition_pud <- auto_decompose(pud_ts)
decomposition_nps <- auto_decompose(nps_ts)

plot(decomposition_pud,lwd = 2)
plot(decomposition_pud,type = "period")
plot(decomposition_pud,type = "classical")


plot(decomposition_nps,legend = TRUE)


plot(decomposition_nps,type = "period")
plot(decomposition_nps,type = "classical")

}
