% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfectpow.R
\name{12. Perfect power}
\alias{12. Perfect power}
\alias{perfectpow}
\alias{perfectpow.default}
\alias{perfectpow.numeric}
\alias{perfectpow.vli}
\alias{is.perfectpow}
\alias{is.perfectpow.default}
\alias{is.perfectpow.numeric}
\alias{is.perfectpow.vli}
\title{Perfect Power Tools for vli Objects}
\usage{
perfectpow(x)

\method{perfectpow}{default}(x)

\method{perfectpow}{numeric}(x)

\method{perfectpow}{vli}(x)

is.perfectpow(x)

\method{is.perfectpow}{default}(x)

\method{is.perfectpow}{numeric}(x)

\method{is.perfectpow}{vli}(x)
}
\arguments{
\item{x}{object of class vli or 32 bits integer}
}
\value{
\code{is.perfectpow(x)} returns a Boolean

\code{perfectpow(x)} returns a list of two objects of class vli
}
\description{
A positive integer is a perfect power if it can be expressed as an integer power of another positive integer. That is, a positive integer \code{x} is a perfect power if there exist two positive integers \code{a} and \code{b} such that \code{x = a^b} (note that \code{a} and \code{b} might not be unique).
}
\details{
The function \code{is.perfectpow(x)} returns \code{TRUE} if there exist two positive integers \code{a} and \code{b} such that \code{x = a^b}, and returns \code{FALSE} if there not exist.

The function \code{perfectpow(x)} returns a list of two vli objects, \code{a} and \code{b}, such that \code{x = a^b}. If there not exist such numbers, the two vli objects will be equal to zero. Although the concept is usually defined only for positive integers, the function has been also programmed to work with negative integers.
}
\examples{
x <- as.vli("234925792")
is.perfectpow(x)

x <- as.vli("77808066022325383192121677734375")
is.perfectpow(x)
res <- perfectpow(x)
res
res[[1]]^res[[2]]
}
\author{
Javier Leiva Cuadrado
}
