% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherfunc.R
\name{fs6_to_fs5}
\alias{fs6_to_fs5}
\title{fsaverage6 to fsaverage5}
\usage{
fs6_to_fs5(surf_data)
}
\arguments{
\item{surf_data}{A N x V matrix object containing the surface data (N row for each subject, V for each vertex), in fsaverage6 (81924 vertices) space. See also SURFvextract() output format.}
}
\value{
A matrix object containing vertex-wise surface data mapped in fsaverage5 space
}
\description{
Remaps vertex-wise surface data in fsaverage6 space to fsaverage5 space using the nearest neighbor approach
}
\examples{
surf_data = runif(81924,min=0, max=100);
fs5_data=fs6_to_fs5(surf_data)
}
\seealso{
\code{\link{fs5_to_fs6}}
}
