% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherfunc.R
\name{atlas_to_surf}
\alias{atlas_to_surf}
\title{Atlas to surface}
\usage{
atlas_to_surf(parcel_data, template)
}
\arguments{
\item{parcel_data}{A matrix or vector object containing average surface measures for each region of interest, see the surf_to_atlas() output format.}

\item{template}{A string object stating the surface space on which to map the data ('fsaverage5', 'fsaverage6' or 'fslr32k').}
}
\value{
A matrix or vector object containing vertex-wise surface data mapped in fsaverage5, fsaverage6 or fslr32k space
}
\description{
Maps average parcellation surface values (e.g. produced with the surf_to_atlas() function) to the fsaverage5, fsaverage6 or fslr32k space
}
\details{
The function currently works with the Desikan-Killiany-70, Schaefer-100, Schaefer-200, Schaefer-400, Glasser-360, or Destrieux-148 atlases. ROI to vertex mapping data for 1 to 4 were obtained from the \href{https://github.com/MICA-MNI/ENIGMA/tree/master/enigmatoolbox/datasets/parcellations}{'ENIGMA toolbox'} ; and data for 5 from \href{https://github.com/nilearn/nilearn/blob/a366d22e426b07166e6f8ce1b7ac6eb732c88155/nilearn/datasets/atlas.py}{'Nilearn' 's nilearn.datasets.fetch_atlas_surf_destrieux} . atlas_to_surf() will automatically detect the atlas based on the number of columns.
}
\examples{
parcel_data = t(runif(100,min=0, max=100));
surf_data = atlas_to_surf(parcel_data, template='fsaverage5');
}
\seealso{
\code{\link{surf_to_atlas}}
}
