RaoTest <-
function(azimuths,Alpha =0.01 ){
	
	TableRaoII<-matrix(c(247.32, 231.22, 221.14, 186.45, 168.02, 111.72, 61.48,
						245.19, 232.98, 211.93, 183.44, 168.66, 116.30, 69.98,
						236.81, 216.05, 206.79, 180.65, 166.30, 118.95, 76.52,
						229.46, 211.57, 202.55, 177.83, 165.05, 121.13, 81.43,
						224.41, 206.91, 198.46, 175.68, 163.56, 122.57, 85.23,
						219.52, 203.17, 195.27, 173.68, 162.36, 123.74, 88.35,
						215.44, 199.91, 192.37, 171.98, 161.23, 124.64, 90.95,
						211.87, 197.04, 189.88, 170.45, 160.24, 125.38, 93.15,
						208.69, 194.51, 187.66, 169.09, 159.33, 125.99, 95.05,
						205.87, 192.25, 185.68, 167.87, 158.50, 126.50, 96.71,
						203.33, 190.23, 183.90, 166.76, 157.75, 126.94, 98.17,
						201.04, 188.39, 182.28, 165.75, 157.06, 127.32, 99.47,
						198.96, 186.72, 180.81, 164.83, 156.43, 127.64, 100.64,
						197.05, 185.19, 179.46, 163.98, 155.84, 127.93, 101.70,
						195.29, 183.78, 178.22, 163.20, 155.29, 128.19, 102.67,
						193.67, 182.48, 177.08, 162.47, 154.78, 128.42, 103.55,
						192.17, 181.27, 176.01, 161.79, 154.31, 128.62, 104.36,
						190.78, 180.15, 175.02, 161.16, 153.86, 128.81, 105.10,
						189.47, 179.10, 174.10, 160.56, 153.44, 128.98, 105.80,
						188.25, 178.11, 173.23, 160.01, 153.05, 129.13, 106.44,
						187.11, 177.19, 172.41, 159.48, 152.68, 129.27, 107.04,
						186.03, 176.32, 171.64, 158.99, 152.32, 129.40, 107.61,
						185.01, 175.50, 170.92, 158.52, 151.99, 129.52, 108.13,
						184.05, 174.73, 170.23, 158.07, 151.67, 129.63, 108.63,
						183.14, 173.99, 169.58, 157.65, 151.37, 129.73, 109.10,
						182.28, 173.29, 168.96, 157.25, 151.08, 129.82, 109.54,
						181.45, 172.63, 168.38, 156.87, 150.80, 129.91, 109.96,
						177.88, 169.74, 165.81, 155.19, 149.59, 130.28, 111.76,
						174.99, 167.39, 163.73, 153.82, 148.60, 130.55, 113.20,
						172.58, 165.44, 162.00, 152.68, 147.76, 130.76, 114.38,
						170.54, 163.79, 160.53, 151.70, 147.05, 130.93, 115.37,
						163.60, 158.13, 155.49, 148.34, 144.56, 131.44, 118.68,
						159.45, 154.74, 152.46, 146.29, 143.03, 131.69, 120.62,
						154.51, 150.69, 148.84, 143.83, 141.18, 131.94, 122.88,
						151.56, 148.26, 146.67, 142.35, 140.06, 132.06, 124.21,
						148.06, 145.38, 144.09, 140.57, 138.71, 132.19, 125.76,
						145.96, 143.66, 142.54, 139.50, 137.89, 132.25, 126.68,
						144.54, 142.48, 141.48, 138.77, 137.33, 132.29, 127.30,
						143.48, 141.60, 140.70, 138.23, 136.91, 132.31, 127.76,
						142.66, 140.93, 140.09, 137.80, 136.59, 132.33, 128.11,
						142.00, 140.38, 139.60, 137.46, 136.33, 132.34, 128.40,
						141.45, 139.93, 139.19, 137.18, 136.11, 132.35, 128.63,
						140.99, 139.54, 138.84, 136.94, 135.92, 132.36, 128.83), ncol=7, byrow=TRUE)
	
	v=sort(azimuths);
	n=length(azimuths);
	Ti<- c(diff(v), 360-(v[n] - v[1]));
	L<-1/2*sum(abs(Ti - 360/n))
	
	if((n>4)){
		if(n<=30){
			Trow<-n-3;
		}
		else{
			if(n <= 32){
				Trow<- 27;
			}
			else{
				if(n <= 37){
					Trow<- 28;
				}
				else{
					if(n <= 42){
						Trow<- 29;
					}
					else{
						if(n <= 47){
							Trow<- 30;
						}
						else{
							if(n <= 62){
								Trow<- 31;
							}
							else{
								if(n <= 87){
									Trow<- 32;
								}
								else{
									if(n <= 125){
										Trow<- 33;
									}
									else{
										if(n <= 175){
											Trow<- 34;
										}
										else{
											if(n <= 250){
												Trow<- 35;
											}
											else{
												if(n <= 350){
													Trow<- 36;
												}
												else{
													if(n <= 450){
														Trow<- 37;
													}
													else{
														if(n <= 550){
															Trow<- 38;
														}
														else{
															if(n <= 650){
																Trow<- 39;
															}
															else{
																if(n <= 750){
																	Trow<- 40;
																}
																else{
																	if(n <= 850){
																		Trow<- 41;
																	}
																	else{
																		if(n <= 950){
																			Trow<- 42;
																		}
																		else{
																			Trow<- 43;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		if(sum(Alpha == c(0.001, 0.005, 0.01, 0.05, 0.1, 0.5, 0.9)) == 0){
			print("Incorrect Alpha");
		}
		else{
			Tcol<-(1:7)[Alpha == c(0.001, 0.005, 0.01, 0.05, 0.1, 0.5, 0.9)]
			value<-TableRaoII[Trow,Tcol];
			if(value>=L){
				print(paste("Test Statistic =",round(L,3)));
				print(paste("Table value=",value));
				print("Rao Test: hypothesis of uniformity is accepted ");
			}
			else{
				print(paste("Test Statistic =",round(L,3)));
				print(paste("Table value=",value));
				print("Rao Test: hypothesis of uniformity is rejected ");
			}
		}	
	}
	else{
		print("Rao Test: Size of sample incorrect");
	}
}

