
#Level 1 test#
### dpqr group - dvg, ddvg, pvg, qvg, rvg, vgCalcRange, vgBreaks

test.vgL1dpqr <- function () {
  dvgReturn1 <- dvg(x = 0)
  ddvgReturn1 <- ddvg(x = 0)
  dvgReturn2 <- dvg(x = 1)
  ddvgReturn2 <- ddvg(x = 1)
  pvgReturn <- pvg(q = 0)
  qvgReturn <- qvg(p = 0.5)
  rvgReturn <- rvg(n =100)  
  vgCalcRangeReturn <- vgCalcRange()
  vgBreaksReturn <-vgBreaks()   
       
  checkTrue(is(dvgReturn1, "numeric"))
  checkEquals(length(dvgReturn1),1)
  checkTrue(is(ddvgReturn1, "numeric"))
  checkEquals(length(ddvgReturn1),1)
  checkTrue(is(dvgReturn2, "numeric"))
  checkEquals(length(dvgReturn2),1)
  checkTrue(is(ddvgReturn2, "numeric"))
  checkEquals(length(ddvgReturn2),1)
  checkTrue(is(pvgReturn, "numeric"))
  checkEquals(length(pvgReturn),1)
  checkTrue(is(qvgReturn, "numeric"))
  checkEquals(length(qvgReturn),1)
  checkTrue(is(rvgReturn, "numeric"))
  checkEquals(length(rvgReturn),100)
  checkTrue(is(vgCalcRangeReturn, "numeric"))
  checkEquals(length(vgCalcRangeReturn), 2)
  checkTrue(is(vgBreaksReturn, "list"))
  checkEquals(length(vgBreaksReturn), 7)
}

### moments group - vgMode, vgMean, vgVar, vgSkew, vgKurt, vgMom
test.vgL1moments <- function () {
  vgModeReturn <- vgMode()
  vgMeanReturn <- vgMean()
  vgVarReturn <- vgVar()
  vgSkewReturn <- vgSkew()
  vgKurtReturn <- vgKurt()
  vgMomReturnRaw8 <- vgMom (order = 8)
  vgMomReturnRaw7 <- vgMom (order = 7)
  vgMomReturnCen8 <- vgMom (order = 8, momType = "central") 
  vgMomReturnCen7 <- vgMom (order = 7, momType = "central") 
  vgMomReturnMu8 <- vgMom (order = 8, momType = "mu") 
  vgMomReturnMu7 <- vgMom (order = 7, momType = "mu") 
  vgMomReturnAbo8 <- vgMom (order = 8, about = 1)
  vgMomReturnAbo7 <- vgMom (order = 7, about = 1)

  checkTrue(is(vgModeReturn, "numeric"))
  checkEquals(length(vgModeReturn),1)  
  checkTrue(is(vgMeanReturn, "numeric"))
  checkEquals(length(vgMeanReturn),1)  
  checkTrue(is(vgMeanReturn, "numeric"))
  checkEquals(length(vgMeanReturn),1) 
  checkTrue(is(vgVarReturn, "numeric"))
  checkEquals(length(vgVarReturn),1) 
  checkTrue(vgVarReturn > 0)
  checkTrue(is(vgSkewReturn, "numeric"))
  checkEquals(length(vgSkewReturn),1) 
  checkTrue(is(vgKurtReturn, "numeric"))
  checkEquals(length(vgKurtReturn),1) 
  checkTrue(is(vgMomReturnRaw8, "numeric"))
  checkEquals(length(vgMomReturnRaw8),1) 
  checkTrue(is(vgMomReturnRaw7, "numeric"))
  checkEquals(length(vgMomReturnRaw7),1) 
  checkTrue(is(vgMomReturnCen8, "numeric"))
  checkEquals(length(vgMomReturnCen8),1) 
  checkTrue(is(vgMomReturnCen7, "numeric"))
  checkEquals(length(vgMomReturnCen7),1) 
  checkTrue(is(vgMomReturnMu8, "numeric"))
  checkEquals(length(vgMomReturnMu8),1) 
  checkTrue(is(vgMomReturnMu7, "numeric"))
  checkEquals(length(vgMomReturnMu7),1) 
  checkTrue(is(vgMomReturnAbo8, "numeric"))
  checkEquals(length(vgMomReturnAbo8),1) 
  checkTrue(is(vgMomReturnAbo7, "numeric"))
  checkEquals(length(vgMomReturnAbo7),1) 
}


### fitting group - vgFitStartMoM, vgFitStart, vgFit
test.vgL1fitting <- function () {
  vgFitStartMoMReturn <- vgFitStartMoM (rvg(100))
  vgFitStartReturn <- vgFitStart(rvg(100))$paramStart
  vgFitNMReturn <- vgFit(rvg(100))
  vgFitBFGSReturn <- vgFit(rvg(100), method = "BFGS")
  vgFitnlmReturn <- vgFit(rvg(100), method = "nlm")
  
  checkTrue(is(vgFitStartMoMReturn, "numeric"))
  checkEquals(length(vgFitStartMoMReturn ),4) 
  checkTrue(is(vgFitStartReturn, "numeric"))
  checkEquals(length(vgFitStartReturn ),4) 
  checkTrue(is.list(vgFitNMReturn))
  checkEquals(length(vgFitNMReturn),14) 
  checkTrue(vgFitNMReturn$param[2] > 0)
  checkTrue(vgFitNMReturn$param[4] > 0)
  checkTrue(is.list(vgFitBFGSReturn))
  checkEquals(length(vgFitBFGSReturn),14)
  checkTrue(vgFitBFGSReturn$param[2] > 0)
  checkTrue(vgFitBFGSReturn$param[4] > 0) 
  checkTrue(is.list(vgFitnlmReturn))
  checkEquals(length(vgFitnlmReturn),14) 
  checkTrue(vgFitnlmReturn$param[2] > 0)
  checkTrue(vgFitnlmReturn$param[4] > 0)
}


### parameters - vgChangePars
test.vgL1parameter <- function () {
  vgChangeParsReturn12 <- vgChangePars(from = 1, to = 2, param = c(0,1,0,1))
  vgChangeParsReturn13 <- vgChangePars(from = 1, to = 3, param = c(0,1,0,1))
  vgChangeParsReturn14 <- vgChangePars(from = 1, to = 4, param = c(0,1,0,1))
  vgChangeParsReturn21 <- vgChangePars(from = 2, to = 1, param = c(0,1,0,1))
  vgChangeParsReturn23 <- vgChangePars(from = 2, to = 3, param = c(0,1,0,1))
  vgChangeParsReturn24 <- vgChangePars(from = 2, to = 4, param = c(0,1,0,1))
  vgChangeParsReturn31 <- vgChangePars(from = 3, to = 1, param = c(0,1,0,1))
  vgChangeParsReturn32 <- vgChangePars(from = 3, to = 2, param = c(0,1,0,1))
  vgChangeParsReturn34 <- vgChangePars(from = 3, to = 4, param = c(0,1,0,1))
  vgChangeParsReturn41 <- vgChangePars(from = 4, to = 1, param = c(0.5,3,1,0))
  vgChangeParsReturn42 <- vgChangePars(from = 4, to = 2, param = c(0.5,3,1,0))
  vgChangeParsReturn43 <- vgChangePars(from = 4, to = 3, param = c(0.5,3,1,0))
  
  checkTrue(is(vgChangeParsReturn12, "numeric"))
  checkEquals(length(vgChangeParsReturn12),4)
  checkTrue(is(vgChangeParsReturn13, "numeric"))
  checkEquals(length(vgChangeParsReturn13),4)
  checkTrue(is(vgChangeParsReturn14, "numeric"))
  checkEquals(length(vgChangeParsReturn14),4)
  checkTrue(is(vgChangeParsReturn21, "numeric"))
  checkEquals(length(vgChangeParsReturn21),4)
  checkTrue(is(vgChangeParsReturn23, "numeric"))
  checkEquals(length(vgChangeParsReturn23),4)
  checkTrue(is(vgChangeParsReturn24, "numeric"))
  checkEquals(length(vgChangeParsReturn24),4)
  checkTrue(is(vgChangeParsReturn31, "numeric"))
  checkEquals(length(vgChangeParsReturn31),4)
  checkTrue(is(vgChangeParsReturn32, "numeric"))
  checkEquals(length(vgChangeParsReturn32),4)
  checkTrue(is(vgChangeParsReturn34, "numeric"))
  checkEquals(length(vgChangeParsReturn34),4)
  checkTrue(is(vgChangeParsReturn41, "numeric"))
  checkEquals(length(vgChangeParsReturn41),4)
  checkTrue(is(vgChangeParsReturn42, "numeric"))
  checkEquals(length(vgChangeParsReturn42),4)
  checkTrue(is(vgChangeParsReturn43, "numeric"))
  checkEquals(length(vgChangeParsReturn43),4)
}