% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{make_pelogit_fnc}
\alias{make_pelogit_fnc}
\title{Create function for backtransforming empirical logits to proportions}
\usage{
make_pelogit_fnc(ObsPerBin = NULL, Constant = NULL)
}
\arguments{
\item{ObsPerBin}{A positive integer indicating the number of observations 
used in the original transformation calculation.}

\item{Constant}{A positive number used in the original transformation calculation.}
}
\value{
A function.
}
\description{
\code{make_pelogit_fnc} creates a function that can transform empirical logit
values back to probability scale using the number of samples and constant
that were used in the original transformation. This function can then be use
to backtransform value predicted by a statistical model.
}
\examples{
\dontrun{
library(VWPre)
# Make backtransformation function
pelogit <- make_pelogit_fnc(20, 0.5)
} 
}
