% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ds_options}
\alias{ds_options}
\title{Determine downsampling options based on current sampling rate}
\usage{
ds_options(SamplingRate)
}
\arguments{
\item{SamplingRate}{A positive integer indicating the sampling rate (in Hertz) 
used to record the gaze data, which can be determined with the function 
\code{\link{check_samplingrate}}.}
}
\value{
A printed summary of options (bin size and rate) for downsampling.
}
\description{
\code{ds_options} determines the possible rates to which 
the current sampling rate can downsampled. It then prints the 
options in both bin size (milliseconds) and corresponding 
sampling rate (Hertz).
}
\examples{
\dontrun{
library(VWPre)
# Determine downsampling options...
ds_options(SamplingRate = 1000)
}
}

