% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_decomp.R
\name{vs_decomp}
\alias{vs_decomp}
\title{Skewness and Variance Decomposition}
\usage{
vs_decomp(
  y = NULL,
  X,
  wgt = rep(1, nrow(X)),
  moment = "skewness",
  year = rep(1, nrow(X))
)
}
\arguments{
\item{y}{an outcome vector (necessary only when decomposing by one variable).}

\item{X}{when decomposing by one variable, a matrix or data frame containing the variable
for the decomposition. when decomposing by more than one variable, a matrix or
data frame containing the linear components of y, calculated by
\code{\link{linear_projection}}.}

\item{wgt}{an optional vector of weights.}

\item{moment}{the moment on which the decomposition method is applied.
either "variance" (second moment) or "skewness" (third moment).}

\item{year}{an optional vector of years. if provided, the decomposition is calculated by year.
otherwise, the decomposition is calculated for the whole sample.}
}
\value{
A "vs_decomp" object. This object is a list containing the estimated
components and their standard errors.
}
\description{
decompose the skewness or the variance of an outcome vector into independent components,
either using one or many variables.
}
\examples{
#generate data
n <- 100
men <- rbinom(n, 1, 0.5)
black <- rbinom(n, 1, 0.5)
year <- c(rep(2019, n/2), rep(2020, n/2))
rwage <- function(x){
  m <- x[1]; b <- x[2]; y <- x[3];
  exp(rnorm(1, mean = 1*m + 1*b, sd = 1 + 2020 - y))
}
dat <- data.frame(men, black, year)
dat$wage <- apply(dat, 1, rwage)
#skewness decomposition by one variable:
variable <- as.matrix(dat$men)
decomp_by_gender <- vs_decomp(y = dat$wage, X = variable,
                              moment = "skew", year = dat$year)
summary(decomp_by_gender)
plot(decomp_by_gender)

#skewness decomposition by more than one variable (=linear skewness decomposition):
#first we need to decompose yearly wages into their linear components
#(check ?linear_projection for more details):
wage_linear_comp <- linear_projection(y = "wage",
                                      X.list = list("men", "black"),
                                      data = dat, year = dat$year)
#using the linear components, we can calculate skewness decomposition:
decomp_by_mult_var <- vs_decomp(X = wage_linear_comp,
                                year = dat$year)
#up to 3 components can be summarized or plotted:
colnames(decomp_by_mult_var$components)
#let's take "3cov(epsilon^2,men)" and "3cov(epsilon^2,black)"
summary(decomp_by_mult_var, sum.comp = c(7, 8))
plot(decomp_by_mult_var, plot.comp = c(7, 8))
}
