
#' Sample datasets of the Stehekin for the running of the VIC model
#' provided by UW Hydro
#'
#' @format
#' A list including meteorological forcing data, soil parameters,
#' vegetation parameters, vegetation library, snowband parameters
#' and vegetation forcing data for 16 0.25 degree gridcells.
#' The dataset is provided by the
#' [Computational Hydrology group](http://uw-hydro.github.io/),
#' Department of Civil and Environmental Engineering at the
#' University of Washington.
#'
#' This is a list containing:
#' \describe{
#'  \item{forcing}{10-day hourly meteorological forcing data from
#' 1949-01-01 to 1949-01-10, including precipitation, air temperature,
#' longwave and shortwave radiation, wind speed, vapor pressure, and
#' air pressure.}
#'  \item{soil}{soil parameters for 16 gridcells.}
#'  \item{veg}{vegetation parameters for 16 gridcells.}
#'  \item{snowbands}{elevation band (snow band) parameters.}
#'  \item{veglib}{vegetation library.}
#'  \item{forcing_veg}{vegetation forcing data including LAI,
#' fraction of canopy, and albedo. This is generated by simply temporally
#' repeat the values of `veglib` according to `veg`.}
#'  \item{runoff_table_daily}{Three-year daily runoff outputs of the
#'  VIC model from 1949-01-01 to 1951-12-31. This is as the sample input data
#'  of the streamflow routing model of Lohmann in the form of output table
#'  returned by [vic()], containing two output variable:
#'  `OUT_RUNOFF` and `OUT_BASEFLOW`.}
#'  \item{streamflow_obs}{Observed streamflow series to be the reference to
#'  evaluate the streamflow simulation results.}
#' }
#'
#' @source
#' <https://github.com/UW-Hydro/VIC_sample_data>
#'
#' <http://uw-hydro.github.io/>
"STEHE"

#' IGBP vegetation library for VIC model
#' 
#' This library is originated from Python package `hydrate`.
#' 
#' @references 
#' 1. https://github.com/KMarkert/hydrate/blob/master/hydrate/lookups/veg_params.py
#' 2. https://github.com/KMarkert/hydrate
#' 
#' @docType data
"veglib_IGBP"
