% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmer.R
\name{plot_mesh}
\alias{plot_mesh}
\title{Visualization of the curves}
\usage{
plot_mesh(U, uhat, v, color_plot, eta_0)
}
\arguments{
\item{U}{A data frame representing resulting images in relative coordinates.}

\item{uhat}{A matrix containing values from the interpolated image with x  y and data and the next column structure

x y date1 date2 date3}

\item{v}{A matrix containing values from the satellite/model based image.

The values of U, uhat and v should correspond to the same pixels in the coordinates matrix.}

\item{color_plot}{A palette of colors from grDevices.}

\item{eta_0}{A scalar representing length scale constant.}
}
\value{
Three 3D plots representing the variation
}
\description{
Using the data of previous functions (mesh_3 and var_merge), three 3D graphs are realized.
Each graph represent in order the variation through the space (longitude and latitude) U,uhat and v.
}
\examples{
\donttest{
data(U,"VARMER")
invisible(force(U))
data(uhat,"VARMER")
invisible(force(uhat))
data(v,"VARMER")
invisible(force(v))
eta_0=0.5
plot_mesh(U,uhat,v,topo.colors,eta_0)
}
}
