% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{first.step.blocks}
\alias{first.step.blocks}
\title{block fused lasso step (first step for BSS).}
\usage{
first.step.blocks(
  data.temp,
  lambda.1.cv,
  lambda.2.cv,
  q,
  max.iteration = max.iteration,
  tol = tol,
  cv.index,
  blocks
)
}
\arguments{
\item{data.temp}{input data matrix, with each column representing the time series component}

\item{lambda.1.cv}{tuning parameter lambda_1 for fused lasso}

\item{lambda.2.cv}{tuning parameter lambda_2 for fused lasso}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{cv.index}{the index of time points for cross-validation}

\item{blocks}{the blocks}
}
\value{
A list object, which contains the followings
\describe{
  \item{brk.points}{a set of selected break point after the first block fused lasso step}
  \item{cv}{the cross validation values for tuning parmeter selection}
  \item{cv1.final}{the selected lambda_1}
  \item{cv2.final}{the selected lambda_2}
}
}
\description{
Perform the block fused lasso to detect candidate break points.
}
