% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.data.R
\name{check.data}
\alias{check.data}
\title{Function to check the dataset of individuals with (1) and without (0) the targeted condition.}
\usage{
check.data(ref, test, model = c("kernel", "binormal", "ordinal"))
}
\arguments{
\item{ref}{The reference standard. A column in a data frame or a vector indicating the classification by the reference test. The reference standard must be coded either as 0 (absence of the condition) or 1 (presence of the condition)}

\item{test}{The index test or test under evaluation. A column in a dataset or vector indicating the test results in a continuous scale.}

\item{model}{The model used for estimation. Default = 'kernel'. When model != ordinal, the dataset is checked whether the test has a sufficient number of different values (>= 20).}
}
\value{
Either a valid dataset as data.frame with two variables ref and test or an error message.
}
\description{
Function to check the dataset of individuals with (1) and without (0) the targeted condition.
}
\details{
The first check is whether ref and test have equal length. If not, checkdata is aborted with an error message.
The second check is whether ref is coded solely with 0 and 1. If not, check.data is aborted and an error message is shown.
The third check is whether ref and test have missing values. If true, list wise deletion is applied and a warning message is shown.
The fourth check is whether test is continuous or not. If test has less than 20 different values, a warning message is shown. This test is omitted when ordinal = TRUE.

This function is called from every function that requires data. A call is only useful to check warnings and errors.
}
\examples{
#' set.seed(1)
ref=c(rep(0,500), rep(1,500))
test=c(rnorm(500,0,1), rnorm(500,1,1.2))
check.data(ref, test) # model = 'kernel'
}
