% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOGLIK.R
\name{logLik.UPG.Binomial}
\alias{logLik.UPG.Binomial}
\title{Compute log-likelihoods from UPG.Binomial objects}
\usage{
\method{logLik}{UPG.Binomial}(object = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{UPG.Binomial}.}

\item{...}{other logLik parameters.}
}
\value{
Returns a numeric of class \code{logLik} with attributes containing the number of estimated parameters and the number of observations.
}
\description{
\code{logLik} can be used to compute log-likelihoods from \code{UPG.Binomial} objects. The log-likelihood is based on the posterior mean of the coefficients.
}
\examples{
\donttest{
# estimate a binomial logit model using example data
library(UPG)
data(titanic)
y  = titanic[,1]
Ni = titanic[,2]
X  = titanic[,-c(1,2)]
results.binomial = UPG(y = y, X = X, Ni = Ni, model = "binomial")

# extract log-likelihood
ll.binomial = logLik(results.binomial)

}
}
\seealso{
\code{\link{summary.UPG.Binomial}} to summarize a \code{UPG.Binomial} object and create tables.
\code{\link{plot.UPG.Binomial}} to plot a \code{UPG.Binomial} object.
\code{\link{coef.UPG.Binomial}} to extract coefficients from a \code{UPG.Binomial} object.
}
\author{
Gregor Zens
}
