% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETSS3functions.R, R/PTSS3functions.R,
%   R/TETSS3functions.R
\name{residuals.ETS}
\alias{residuals.ETS}
\alias{residuals.PTS}
\alias{residuals.TETS}
\title{residuals.ETS}
\usage{
\method{residuals}{ETS}(object, ...)

\method{residuals}{PTS}(object, ...)

\method{residuals}{TETS}(object, ...)
}
\arguments{
\item{object}{Object of class \dQuote{TETS}.}

\item{...}{Additional inputs to function.}
}
\description{
Residuals of ETS object

Residuals of PTS object

Residuals of TETS object
}
\details{
See help of \code{ETS}.

See help of \code{PTS}.

See help of \code{TETS}.
}
\examples{
\dontrun{
m1 <- ETSmodel(log(gdp))
residuals(m1)
}
\dontrun{
m1 <- PTSmodel(log(AirPassengers))
residuals(m1)
}
\dontrun{
m1 <- TETSmodel(log(gdp))
residuals(m1)
}
}
\seealso{
\code{\link{ETS}}, \code{\link{ETSmodel}}, \code{\link{ETSvalidate}},
         \code{\link{ETScomponents}}, \code{\link{ETSestim}}

\code{\link{PTS}}, \code{\link{PTSmodel}}, \code{\link{PTSvalidate}},
         \code{\link{PTScomponents}}, \code{\link{PTSestim}}

\code{\link{TETS}}, \code{\link{TETSmodel}}, \code{\link{TETSvalidate}},
         \code{\link{TETScomponents}}, \code{\link{TETSestim}}
}
\author{
Diego J. Pedregal
}
