% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_analyze_gene_drug_response.R
\name{vis_gene_drug_response_diff}
\alias{vis_gene_drug_response_diff}
\title{Visualize Gene and Drug Response Difference with CCLE Data}
\usage{
vis_gene_drug_response_diff(
  Gene = "TP53",
  tissue = "lung",
  Show.P.label = TRUE,
  Method = "wilcox.test",
  values = c("#DF2020", "#DDDF21"),
  alpha = 0.5
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{tissue}{select cell line origin tissue.}

\item{Show.P.label}{\code{TRUE} or \code{FALSE} present p value with number or label \code{*}, \verb{**}, \verb{***} and \verb{****}}

\item{Method}{default method is wilcox.test}

\item{values}{the color to fill tumor or normal}

\item{alpha}{set alpha for dots.}
}
\value{
a \code{ggplot} object.
}
\description{
See \link{analyze_gene_drug_response_diff} for examples.
}
