% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TukeyGH.R
\name{TukeyGH}
\alias{TukeyGH}
\alias{dGH}
\alias{rGH}
\alias{qGH}
\alias{pGH}
\title{Tukey's \eqn{g}-&-\eqn{h} Distribution}
\usage{
dGH(x, A = 0, B = 1, g = 0, h = 0, log = FALSE, ...)

rGH(n, A = 0, B = 1, g = 0, h = 0)

qGH(p, A = 0, B = 1, g = 0, h = 0, lower.tail = TRUE, log.p = FALSE)

pGH(q, A = 0, B = 1, g = 0, h = 0, lower.tail = TRUE, log.p = FALSE, ...)
}
\arguments{
\item{x, q}{\link[base]{double} \link[base]{vector}, quantiles}

\item{A}{\link[base]{double} scalar, location parameter \eqn{A}, default \eqn{A=0} (as parameter \code{mean} of \link[stats]{dnorm})}

\item{B}{\link[base]{double} scalar, scale parameter \eqn{B>0}, default \eqn{B=1} (as parameter \code{sd} of \link[stats]{dnorm})}

\item{g}{\link[base]{double} scalar, skewness parameter \eqn{g}, default \eqn{g=0} indicating no skewness}

\item{h}{\link[base]{double} scalar, elongation parameter \eqn{h\geq 0}, default \eqn{h=0} indicating no kurtosis}

\item{log, log.p}{\link[base]{logical} scalar, if \code{TRUE}, probabilities \eqn{p} are given as \eqn{\log(p)}.}

\item{...}{other parameters of function \link{vuniroot2}}

\item{n}{\link[base]{integer} scalar, number of observations}

\item{p}{\link[base]{double} \link[base]{vector}, probabilities}

\item{lower.tail}{\link[base]{logical} scalar, if \code{TRUE} (default), probabilities are \eqn{Pr(X\le x)} otherwise, \eqn{Pr(X>x)}.}
}
\value{
Function \link{dGH} gives the density and accommodates \link[base]{vector} arguments \code{A}, \code{B}, \code{g} and \code{h}.
The quantiles \code{x} can be either \link[base]{vector} or matrix.
This function takes about 1/5 time of \code{gk::dgh}.

Function \link{pGH} gives the distribution function, only taking scalar arguments and \link[base]{vector} quantiles \eqn{q}.
This function takes about 1/10 time of function \code{gk::pgh}.

Function \link{qGH} gives the quantile function, only taking scalar arguments and \link[base]{vector} probabilities \eqn{p}.

Function \link{rGH} generates random deviates, only taking scalar arguments.
}
\description{
Density, distribution function, quantile function and simulation
for the Tukey's \eqn{g}-&-\eqn{h} distribution with
location parameter \eqn{A},
scale parameter \eqn{B},
skewness \eqn{g} and
elongation \eqn{h}.
}
\details{
Argument \code{A}, \code{B}, \code{g} and \code{h} will be recycled to the maximum length of the four.
}
\note{
Function \code{gk:::z2gh} is only an \emph{approximation} to Tukey's \eqn{g}-&-\eqn{h} transformation.
}
\examples{
(x = c(NA_real_, rGH(n = 5L, g = .3, h = .1)))
dGH(x, g = c(0,.1,.2), h = c(.1,.1,.1))

p0 = seq.int(0, 1, by = .2)
(q0 = qGH(p0, g = .2, h = .1))
range(pGH(q0, g = .2, h = .1) - p0)

q = (-2):3; q[2L] = NA_real_; q
(p1 = pGH(q, g = .3, h = .1))
range(qGH(p1, g = .3, h = .1) - q, na.rm = TRUE)
(p2 = pGH(q, g = .2, h = 0))
range(qGH(p2, g = .2, h = 0) - q, na.rm = TRUE)

curve(dGH(x, g = .3, h = .1), from = -2.5, to = 3.5)

}
