% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmvnorm.R
\name{pmvnorm}
\alias{pmvnorm}
\title{Distribution function of the multivariate normal distribution for arbitrary limits}
\usage{
pmvnorm(
  mu,
  sigma,
  lb = -Inf,
  ub = Inf,
  B = 10000,
  type = c("mc", "qmc"),
  log = FALSE
)
}
\arguments{
\item{mu}{vector of location parameters}

\item{sigma}{covariance matrix}

\item{lb}{vector of lower truncation limits}

\item{ub}{vector of upper truncation limits}

\item{B}{number of replications for the (quasi)-Monte Carlo scheme}

\item{type}{string, either of \code{mc} or \code{qmc} for Monte Carlo and quasi Monte Carlo, respectively}

\item{log}{logical; if \code{TRUE}, probabilities and density are given on the log scale.}
}
\description{
This function computes the distribution function of a multivariate normal distribution vector for an arbitrary rectangular region [\code{lb}, \code{ub}].
\code{pmvnorm} computes an estimate and the value is returned along with a relative error and a deterministic upper bound of the distribution function of the multivariate normal distribution.
Infinite values for vectors \eqn{u} and \eqn{l} are accepted. The Monte Carlo method uses sample size \eqn{n}: the larger the sample size, the smaller the relative error of the estimator.
}
\examples{
#From mvtnorm
mean <- rep(0, 5)
lower <- rep(-1, 5)
upper <- rep(3, 5)
corr <- matrix(0.5, 5, 5) + diag(0.5, 5)
prob <- pmvnorm(lb = lower, ub = upper, mu = mean, sigma = corr)
stopifnot(pmvnorm(lb = -Inf, ub = 3, mu = 0, sigma = 1) == pnorm(3))
}
\references{
Z. I. Botev (2017), \emph{The normal law under linear restrictions:
simulation and estimation via minimax tilting}, Journal of the Royal
Statistical Society, Series B, \bold{79} (1), pp. 1--24.
}
\seealso{
\code{\link[mvtnorm]{pmvnorm}}
}
\author{
Zdravko I. Botev, Leo Belzile (wrappers)
}
