% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.select_Millar.R
\name{plot.select_Millar}
\alias{plot.select_Millar}
\title{Millar's selectivity plot}
\usage{
\method{plot}{select_Millar}(x, plotlens = NULL, standardise = TRUE,
  deviance_plot = TRUE, selectivity_plot = TRUE, xlab_dev = "Length [cm]",
  xlab_sel = "Length [cm]", ylab_dev = "Mesh size [cm]",
  ylab_sel = "Relative retention", title_dev = "Deviance residuals",
  title_sel = NULL, ...)
}
\arguments{
\item{x}{a list of the class \code{"select_Millar"} containing the results of
Millar's selectivity model}

\item{plotlens}{A vector with lengths which should be used for drawing the
selection curves}

\item{standardise}{A parameter indicating if the retention should be realtive
to the maximum value (Default: TRUE).}

\item{deviance_plot}{logical (Default: TRUE); indicating whether a plot of deviance residuals should
be displayed}

\item{selectivity_plot}{logical (Default: TRUE); indicating whether a plot of relative retention selectivities
should be displayed}

\item{xlab_dev}{character string. Label for x axis of deviance plot. Default: "Length [cm]"}

\item{xlab_sel}{character string. Label for x axis of selectivity plot. Default: "Length [cm]"}

\item{ylab_dev}{character string. Label for y axis of deviance plot. Default: "Mesh size [cm]"}

\item{ylab_sel}{character string. Label for y axis of selectivity plot. Default: "Relative retention".}

\item{title_dev}{character string. Label for main title of deviance plot. Default: "Deviance residuals".}

\item{title_sel}{character string. Label for main title of selectivity plot. Default is
taken from the results of the select_Millar (e.g. res$rtype).}

\item{...}{additional parameter options from plot function}
}
\description{
This function plots the selectivity estimates of Millar's
   selectivity model (\code{\link{select_Millar}}).
}
\details{
This function draws a selectivity plot for the object class
   \code{"select_Millar"}, which is created by applying Millar's selectivity model
   \code{\link{select_Millar}}.
}
\examples{
data(gillnet)

output <- select_Millar(gillnet, x0 = c(60,4), rel.power = rep(1,8),
   rtype = "norm.loc", plot = FALSE)

plot(output, plotlens = seq(40,90,0.1), deviance_plot = FALSE)

}
\references{
Millar, R. B., Holst, R., 1997. Estimation of gillnet and hook selectivity
 using log-linear models. \emph{ICES Journal of Marine Science: Journal du Conseil},
 54(3), 471-477.
}
