% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catchCurve.R
\name{catchCurve}
\alias{catchCurve}
\title{Catch curve}
\usage{
catchCurve(param, catch_columns = NA, cumulative = FALSE,
  calc_ogive = FALSE, reg_int = NULL)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \code{midLengths} or \code{age}: midpoints of the length classes (length-frequency
  data) or ages (age composition data),
  \item \code{Linf}: infinite length for investigated species in cm [cm],
  \item \code{K}: growth coefficent for investigated species per year [1/year],
  \item \code{t0}: theoretical time zero, at which individuals of this species hatch,
  \item \code{catch}: catches, vector or matrix with catches of subsequent years if
  the catch curve with constat time intervals should be applied;
}}

\item{catch_columns}{numerical; indicating the column of the catch matrix which should be
used for the analysis.}

\item{cumulative}{logical; if TRUE the cumulative
catch curve is applied (Jones and van Zalinge method)}

\item{calc_ogive}{logical; if TRUE the selection ogive is additionally
calculated from the catch curve (only if \code{cumulative = FALSE})}

\item{reg_int}{instead of using the identity method a range can be determined,
which is to be used for the regression analysis. If equal to NULL identity method
is applied (default).}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{classes.num}, \strong{tplusdt_2}, \strong{t_midL}, or
     \strong{ln_Linf_L}: age, relative age or subsitute depending on input and method,
  \item \strong{lnC} or \strong{lnC_dt}: logarithm of (rearranged) catches,
  \item \strong{reg_int}: the interval used for the regression analysis,
  \item \strong{linear_mod}: linear model used for the regression analysis,
  \item \strong{Z}: instantaneous total mortality rate, confidenceInt
  \item \strong{se}: standard error of the total mortality;
  \item \strong{confidenceInt}: confidence interval of the total mortality;}
in case calc_ogive == TRUE, additionally:
\itemize{
  \item \strong{intercept}: intercept of regression analysis,
  \item \strong{linear_mod_sel}: linear model used for the selectivity analysis,
  \item \strong{Sobs}: observed selection ogive,
  \item \strong{ln_1_S_1}: dependent variable of regression analysis for
  selectivity parameters,
  \item \strong{Sest}: estimated selection ogive,
  \item \strong{t50}: age at first capture (age at which fish have a 50%
  probability to be caught),
  \item \strong{t75}: age at which fish have a 75% probability to be caught,
  \item \strong{L50}: length at first capture (length at which fish have a 50%
  probability to be caught),
  \item \strong{L75}: length at which fish have a 75% probability to be caught;
}
}
\description{
This function applies the (length-converted) linearised catch
   curve to age composition and length-frequency data,
   respectively. It allows to estimate the instantaneous total mortality rate (Z).
   Optionally, the gear selectivity can be estimated and the cumulative catch
   curve cna be applied.
}
\details{
This function includes the \link{identify} function, which asks you to
  choose two points from a graph manually. The two points which you choose by clicking
  on the plot in the graphical device represent the start and end of the data points,
  which should be used for the analysis. Based on these points the regression line
  is calculated.
  When the selection ogive
  is calculated by means of the catch curve the assumption is made, that Z is constant
  for all year classes or length groups, respectively. Accoring to Sparre and Venema
  (1998) this assumption might be true, because F is smaller for young fish
  (Selectivity) while M is higher for young fish (high natural mortality). The selectivity
  for not fully exploited old fish (e.g. due to gillnet fishery) can not be calculated yet
  by use of the catch curve.
  Based on the format of the list argument \code{catch} and whether the argument
  \code{catch_columns} is defined, the function automatically
  distinguishes between the catch curve with variable parameter system (if catch is a
  vector) and the one with constant parameter system (if catch is a matrix or a
  data.frame and \code{catch_columns = NA}). In the case of the variable parameter
  system the catches of one year are
  assumed to represent the catches during the entire life span of a so called
  pseudo-cohort.
  The cumulative catch curve does not allow for the estimation of the selectivity
  ogive.
}
\examples{
\donttest{
#_______________________________________________
# Variable paramter system (with catch vector)
# based on length frequency data
data(goatfish)
output <- catchCurve(goatfish)
summary(output$linear_mod)

# based on age composition data
data(whiting)
catchCurve(whiting, catch_columns = 1)

#_______________________________________________
# Constant parameter system based on age composition data (with catch matrix)
catchCurve(whiting)

#_______________________________________________
# Cumulative Catch Curve
# based on length frequency data
data(goatfish)
catchCurve(goatfish, cumulative = TRUE)

# based on age composition data
data(synCAA2)
catchCurve(synCAA2, cumulative = TRUE)

#_______________________________________________
# Catch Curve with estimation of selection ogive
data(synLFQ3)
output <- catchCurve(synLFQ3, calc_ogive = TRUE)
summary(output$linear_mod_sel)
 }

}
\references{
Baranov, F.I., 1926. On the question of the dynamics of the fishing industry.
\emph{Nauchn. Byull. Rybn. Khoz}, 8 (1925), 7-11

Beverton, R.J.H. and S.J. Holt, 1956. A review of methods for estimating mortality
rates in exploited fish populations, with special reference to sources of bias in
catch sampling. \emph{Rapports et Proces verbaux des Reunions}, Conseil Table3

Chapman, D., and D.S Robson, 1960. The analysis of a catch curve.
\emph{Biometrics}, 354-368

Edser, T., 1908. Note on the number of plaice at each length, in certain samples
from the southern part of the North Sea, 1906. \emph{Journal of the Royal
Statistical Society}, 686-690

Heincke, F., 1913. Investigations on the plaice. General report. 1. The plaice fishery
and protective regulations. Part I. \emph{Rapp.P.-v.Reun.CIEM}, 17A:1-153 + Annexes

ICES, 1981. Report of the \emph{Ad hoc} working group on the use of effort data in
assessment, Copenhagen, 2-6 March 1981. \emph{ICES C.M.} 1981/G:5 (mimeo)

Jones, R., and N.P. Van Zalinge, 1981. Estimates of mortality rate and population size
for shrimp in Kuwait waters. \emph{Kuwait Bull. Mar. Sci}, 2, 273-288

Pauly, D., 1983. Length-converted catch curves: a powerful tool for fisheries research
in the tropics (part I). \emph{ICLARM Fishbyte}, 1(2), 9-13

Pauly, D., 1984. Length-converted catch curves: a powerful tool for fisheries
research in the tropics (part II). \emph{ICLARM Fishbyte}, 2(1), 17-19

Pauly, D., 1984. Length-converted catch curves: a powerful tool for fisheries
research in the tropics (III: Conclusion). \emph{ICLARM Fishbyte}, 2(3), 9-10

Ricker, W.E., 1987. Computation and interpretation of biological statistics of fish
populations. \emph{Bull.Fish.Res.Board Can.}, (191):382 p.

Robson, D.S., and D.G. Chapman, 1961. Catch curves and mortality rates.
\emph{Trans.Am.Fish.Soc.}, 90(2):181-189

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.

Van Sickle, J. 1977. Mortality rates from size distributions: the application of a
conservation law. \emph{Oecologia, Berl.}, 27(4):311-318
}
\keyword{Z}
\keyword{catchCurve}
\keyword{function}
\keyword{mortality}

