% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reweight.R
\name{Reweight}
\alias{Reweight}
\title{Reweight phylogenetic characters}
\usage{
Reweight(dataset, weights)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class \code{phyDat},
or as a matrix in the format produced by \code{\link[=PhyDatToMatrix]{PhyDatToMatrix()}}.}

\item{weights}{Unnamed integer vector specifying desired weight of each
character in turn; or named integer vector specifying weights of each
character; unnamed entries will be assigned weight 1.}
}
\value{
\code{Reweight()} returns \code{dataset} after adjusting the weights of
the specified characters.
For a matrix, this is attained by repeating each column the \code{weights} times.
For a \code{phyDat} object, the "weight" attribute will be modified.
}
\description{
\code{Reweight()} allows the weights of specific characters in phylogenetic
datasets to be arbitrarily adjusted.
}
\details{
This functionality should be employed with care.
The underlying principle of parsimony is that all evolutionary steps are
equivalent.
Setting different weights to different characters is at odds with that
principle, so analysis of a re-weighted matrix using a parsimony-based
framework is arguably no longer parsimony analysis; on the most permissive
view, the criteria used to determine a weighting scheme will always
be arbitrary.

It can be useful to relax the criterion that all evolutionary steps are
equivalent -- for example, implied weighting
\insertCite{Goloboff1997}{TreeTools} typically recovers better trees than
equal-weights parsimony \insertCite{Smith2019}{TreeTools}.
This said, assigning different weights to different characters tacitly
imposes a model of evolution that differs from that implicit in equal-weights
parsimony.  Whereas probabilistic models can be evaluated by various methods
(e.g. fit, marginal likelihood, posterior predictive power), there are no
principled methods of comparing different models under a parsimony framework.

As such, \code{Reweight()} is likely to be useful for a narrow set of uses.
Examples may include:
\itemize{
\item informal robustness testing, to explore whether certain characters are
more or less influential on the resulting tree;
\item Imposing constraints on a dataset, by adding each constraint as a column
in a dataset whose weight exceeds the total amount of data.
}
}
\examples{
mat <- rbind(a = c(0, 2, 0), b = c(0, 2, 0), c = c(1, 3, 0), d = c(1, 3, 0))
dat <- MatrixToPhyDat(mat)

 # Set character 1 to weight 1, character 2 to weight 2; omit character 3
Reweight(mat, c(1, 2, 0))
# Equivalently:
Reweight(dat, c("3" = 0, "2" = 2))
}
\references{
\insertAllCited{}
}
\seealso{
Other phylogenetic matrix conversion functions: 
\code{\link{Decompose}()},
\code{\link{MatrixToPhyDat}()},
\code{\link{StringToPhyDat}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{phylogenetic matrix conversion functions}
