% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{RootNode}
\alias{RootNode}
\title{Which node is a tree's root?}
\usage{
RootNode(x)
}
\arguments{
\item{x}{A tree of class \code{phylo}, or its edge matrix; or a list or
\code{multiPhylo} object containing multiple trees.}
}
\value{
\code{RootNode()} returns an integer denoting the root node for each tree.
Badly conformed trees trigger an error.
}
\description{
\code{RootNode()} identifies the root node of a (rooted or unrooted) phylogenetic
tree.
Unrooted trees are represented internally by a rooted tree with a polytomy
at the root.
}
\examples{
RootNode(BalancedTree(8))
RootNode(UnrootTree(BalancedTree(8)))


}
\seealso{
Test whether a tree is rooted: \code{\link[=TreeIsRooted]{TreeIsRooted()}}

\code{phangorn::getRoot()}

Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
