% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{ExtractTaxa}
\alias{ExtractTaxa}
\alias{NexusTokens}
\title{Extract taxa from a matrix block}
\usage{
ExtractTaxa(matrixLines, character_num = NULL, continuous = FALSE)

NexusTokens(tokens, character_num = NULL)
}
\arguments{
\item{matrixLines}{Character vector containing lines of a file that include
a phylogenetic matrix. See \code{\link[=ReadCharacters]{ReadCharacters()}} for expected format.}

\item{character_num}{Index of character(s) to return.
\code{NULL}, the default, returns all characters.}

\item{continuous}{Logical specifying whether characters are continuous.
Treated as discrete if \code{FALSE}.}

\item{tokens}{Vector of character strings corresponding to phylogenetic
tokens.}
}
\value{
\code{ExtractTaxa()} returns a matrix with \emph{n} rows, each named for the
relevant taxon, and \emph{c} columns,
each corresponding to the respective character specified in \code{character_num}.

\code{NexusTokens()} returns a character vector in which each entry
corresponds to the states of a phylogenetic character, or a list containing
an error message if input is invalid.
}
\description{
Extract leaf labels and character states from a Nexus-formatted matrix.
}
\examples{
fileName <- paste0(system.file(package = "TreeTools"),
                   "/extdata/input/dataset.nex")
matrixLines <- readLines(fileName)[6:11]
ExtractTaxa(matrixLines)

NexusTokens("01[01]-?")
}
\keyword{internal}
